/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.internal.core.connection.IResponse;

public class FileResponse
implements IResponse {
    protected URL url;
    protected long lastModified;

    protected FileResponse(URL url) {
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException, CoreException {
        return this.getInputStream();
    }

    public long getContentLength() {
        return 0L;
    }

    public int getStatusCode() {
        return 200;
    }

    public String getStatusMessage() {
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            File f = new File(this.url.getFile());
            if (f.isDirectory()) {
                f = new File(f, "site.xml");
            }
            this.lastModified = f.lastModified();
        }
        return this.lastModified;
    }
}

