/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FileFolderSelectionDialog;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariablesGroup;

public final class PathVariableSelectionDialog
extends SelectionDialog {
    private static final int EXTEND_ID = 1025;
    private PathVariablesGroup pathVariablesGroup;
    private int variableType;

    public PathVariableSelectionDialog(Shell parentShell, int variableType) {
        super(parentShell);
        this.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_title);
        this.variableType = variableType;
        this.pathVariablesGroup = new PathVariablesGroup(false, variableType, new Listener(){

            public void handleEvent(Event event) {
                PathVariableSelectionDialog.this.updateExtendButtonState();
            }
        });
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            FileFolderSelectionDialog dialog = new FileFolderSelectionDialog(this.getShell(), false, this.variableType);
            PathVariablesGroup.PathVariableElement selection = this.pathVariablesGroup.getSelection()[0];
            dialog.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_title);
            dialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_description, (Object)selection.name));
            try {
                dialog.setInput(EFS.getStore((URI)URIUtil.toURI((IPath)selection.path)));
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
            }
            if (dialog.open() == 0 && this.pathVariablesGroup.performOk()) {
                this.setExtensionResult(selection, (IFileStore)dialog.getResult()[0]);
                super.okPressed();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.path_variable_selection_dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1025, IDEWorkbenchMessages.PathVariableSelectionDialog_extendButton, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateExtendButtonState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.pathVariablesGroup.createContents(dialogArea);
        return dialogArea;
    }

    public boolean close() {
        this.pathVariablesGroup.dispose();
        return super.close();
    }

    protected void okPressed() {
        if (this.pathVariablesGroup.performOk()) {
            PathVariablesGroup.PathVariableElement[] selection = this.pathVariablesGroup.getSelection();
            Object[] variableNames = new String[selection.length];
            int i = 0;
            while (i < selection.length) {
                variableNames[i] = selection[i].name;
                ++i;
            }
            this.setSelectionResult(variableNames);
        } else {
            this.setSelectionResult(null);
        }
        super.okPressed();
    }

    private void setExtensionResult(PathVariablesGroup.PathVariableElement variable, IFileStore extensionFile) {
        Path extensionPath = new Path(extensionFile.toString());
        int matchCount = extensionPath.matchingFirstSegments(variable.path);
        Path resultPath = new Path(variable.name);
        extensionPath = extensionPath.removeFirstSegments(matchCount);
        resultPath = resultPath.append((IPath)extensionPath);
        this.setSelectionResult(new String[]{resultPath.toOSString()});
    }

    private void updateExtendButtonState() {
        PathVariablesGroup.PathVariableElement[] selection = this.pathVariablesGroup.getSelection();
        Button extendButton = this.getButton(1025);
        if (extendButton == null) {
            return;
        }
        if (selection.length == 1) {
            IFileInfo info = IDEResourceInfoUtils.getFileInfo(selection[0].path);
            if (info.exists() && info.isDirectory()) {
                extendButton.setEnabled(true);
            } else {
                extendButton.setEnabled(false);
            }
        } else {
            extendButton.setEnabled(false);
        }
    }
}

