/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.akj_betas.wizards;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.akj_betas.wizards.ChooseOutputWizardPage;
import jp.sourceforge.akjrcp.akj_betas.wizards.FileListWizardPage;
import jp.sourceforge.akjrcp.dvdstyler.DVDStylerData;
import jp.sourceforge.akjrcp.dvdstyler.DVDStylerTitle;
import jp.sourceforge.akjrcp.flvtools.basic.SimpleView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.w3c.dom.Document;

public class DVDStylerExportWizard
extends Wizard {
    public static Log log = LogFactory.getLog(DVDStylerExportWizard.class);
    private FileListWizardPage page1;
    private ChooseOutputWizardPage page2;

    public DVDStylerExportWizard() {
        this.setWindowTitle(Messages.getString("dvdstyler.export_wizard_title"));
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        SimpleView.log.info((Object)"addpage");
        this.page1 = new FileListWizardPage("file list");
        this.page2 = new ChooseOutputWizardPage("output file");
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        DVDStylerData dvd = new DVDStylerData();
        if (this.page2.getVersion() == 1) {
            dvd.setFormat(1);
        }
        File[] files = this.page1.getFileList();
        int i = 0;
        while (i < files.length) {
            String command = DVDStylerData.createJumpTitle(i + 1 + 1);
            if (i == files.length - 1) {
                command = this.page2.isLoop() ? DVDStylerData.createJumpVmgmMenu(1) : "";
            }
            DVDStylerTitle title = new DVDStylerTitle(files[i].getAbsolutePath(), command);
            dvd.addTitle(title);
            ++i;
        }
        Document doc = dvd.toDocument();
        String path = this.page2.getSavePath();
        this.writeXML(doc, path);
        if (this.page2.isLaunch()) {
            this.launchDVDStyler(path);
        }
        return true;
    }

    private void launchDVDStyler(String path) {
        Runtime runtime = Runtime.getRuntime();
        String dvdstylerpath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("dvdstyler.path");
        if (dvdstylerpath.length() > 0) {
            File exe = new File(dvdstylerpath);
            if (exe.exists()) {
                String[] args = new String[]{dvdstylerpath, path};
                try {
                    runtime.exec(args);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                log.warn((Object)("dvd styler not found:" + dvdstylerpath));
            }
        } else {
            log.warn((Object)"dvd styler path is empty");
        }
    }

    public void writeXML(Document document, String path) {
        log.info((Object)path);
        log.info((Object)document);
        XMLSerializer serial = new XMLSerializer();
        Writer writer = null;
        try {
            OutputFormat format = new OutputFormat();
            format.setEncoding("UTF-8");
            format.setLineSeparator("\r\n");
            format.setIndenting(true);
            serial.setOutputFormat(format);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path)), "UTF-8"));
            serial.setOutputCharStream(writer);
        }
        catch (IOException e1) {
            log.info((Object)e1.getMessage());
            e1.printStackTrace();
        }
        try {
            log.info((Object)"start serialize");
            serial.serialize(document);
            log.info((Object)"end serialize");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            log.info((Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

