/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamMonitor {
    Log log = LogFactory.getLog(StreamMonitor.class);
    Process process;
    boolean monitor;
    BufferedReader inputReader;
    BufferedReader errorReader;

    public StreamMonitor(Process process) {
        this.process = process;
    }

    public void startMonitor() {
        this.monitor = true;
        new ErrorMonitor().start();
        new InputMonitor().start();
    }

    public void stop() {
        try {
            this.inputReader.close();
            this.errorReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class ErrorMonitor
    extends Thread {
        public void run() {
            InputStream input = StreamMonitor.this.process.getErrorStream();
            StreamMonitor.this.inputReader = new BufferedReader(new InputStreamReader(input));
            try {
                String line2;
                while ((line2 = StreamMonitor.this.inputReader.readLine()) != null) {
                    StreamMonitor.this.log.info((Object)line2);
                }
                StreamMonitor.this.inputReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class InputMonitor
    extends Thread {
        public void run() {
            InputStream input = StreamMonitor.this.process.getInputStream();
            StreamMonitor.this.errorReader = new BufferedReader(new InputStreamReader(input));
            try {
                String line2;
                while ((line2 = StreamMonitor.this.errorReader.readLine()) != null) {
                    StreamMonitor.this.log.info((Object)line2);
                }
                StreamMonitor.this.errorReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

