/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.dropsomething.PSPConvertTabBuilder;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView;
import jp.sourceforge.akjrcp.flvtools.explorer.FFMpegExecutable;
import jp.sourceforge.akjrcp.psp.PSPFFMpegPreference;
import jp.sourceforge.akjrcp.psp.PSPMovieSetting;
import jp.sourceforge.akjrcp.psp.PSPMovieSettingTableViewer;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;

public class FFMpegExplorerExecuter
extends Thread {
    public static Log log = LogFactory.getLog(FFMpegExplorerExecuter.class);
    private String extension;
    private File[] convertingFile;
    private FFMpegExecutable ffmpegExecutable;
    private File exportBaseDir;
    private boolean converting = true;
    private Process currentProcess;

    public FFMpegExplorerExecuter(FFMpegExecutable executable) {
        this.ffmpegExecutable = executable;
    }

    public void cancel() {
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
        }
        this.converting = false;
    }

    public void debugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(v) + "\n");
    }

    public boolean isImageExport(String extension) {
        return extension.equals("png") || extension.equals("jpg") || extension.equals("gif");
    }

    public void startExecute() {
        this.ffmpegExecutable.startExecute(this.convertingFile);
        this.start();
    }

    public void run() {
        int i = 0;
        while (i < this.convertingFile.length) {
            if (!this.converting) break;
            this.ffmpegExecutable.executingFile(this.convertingFile[i], i);
            ExplorerView.log.info((Object)("converting:" + this.convertingFile[i]));
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorStartSubTask(this.convertingFile[i].getName()));
            ProcessMonitor monitor = null;
            Runtime runtime = Runtime.getRuntime();
            ArrayList<String> param = new ArrayList<String>();
            IPreferenceStore store = Akj_betasPlugin.getDefault().getPreferenceStore();
            String ffmpegPath = store.getString("ffmpeg_path");
            FLVInfomation flvInfo = new FFMpegFLVParser(ffmpegPath).parseFile(this.convertingFile[i]);
            param.add(ffmpegPath);
            param.add("-i");
            param.add(this.convertingFile[i].getAbsolutePath());
            if (this.isImageExport(this.extension)) {
                param.add("-f");
                param.add("image2");
                param.add("-ss");
                param.add(store.getString("image_time"));
                param.add("-vframes");
                param.add("1");
            } else {
                param.add("-b");
                param.add(store.getInt("video_bitrate") + "k");
                param.add("-ab");
                param.add(store.getInt("audio_bitrate") + "k");
                param.add("-ar");
                param.add("" + store.getInt("export.wave.samplerate"));
                param.add("-ac");
                param.add("" + store.getInt("export.wave.channel"));
                param.add("-r");
                param.add(store.getString("video_fps"));
                String optionString = store.getString("ffmpeg_option");
                if (this.extension.equals("avi")) {
                    param.add("-vcodec");
                    String avicodec = store.getString("avisetting.video");
                    param.add(avicodec);
                    if (avicodec.equals("xvid")) {
                        param.add("-vtag");
                        param.add("XVID");
                    }
                    param.add("-acodec");
                    param.add(store.getString("avisetting.audio"));
                } else if (this.extension.equals("wmv")) {
                    param.add("-vcodec");
                    param.add(store.getString("wmvsetting.video"));
                    param.add("-acodec");
                    param.add(store.getString("wmvsetting.audio"));
                    if (this.isOdd(flvInfo.getVideoWidth(), flvInfo.getVideoHeight())) {
                        param.add("-s");
                        String newSize = this.fixOddSize(flvInfo.getVideoWidth(), flvInfo.getVideoHeight());
                        param.add(newSize);
                    }
                } else if (this.extension.equals("mp3")) {
                    param.add("-acodec");
                    param.add("mp3");
                } else if (this.extension.equals("mpg")) {
                    param.add("-vcodec");
                    param.add(store.getString("mpegsetting.video"));
                    param.add("-acodec");
                    param.add(store.getString("mpegsetting.audio"));
                    if (store.getString("mpegsetting.mpeg_type").equals("mpeg_type_cbr")) {
                        param.add("-maxrate");
                        param.add(store.getInt("video_bitrate") + "k");
                        param.add("-minrate");
                        param.add(store.getInt("video_bitrate") + "k");
                        param.add("-bufsize");
                        param.add("128k");
                    }
                }
                String[] options = optionString.split(" ");
                int j = 0;
                while (j < options.length) {
                    param.add(options[j]);
                    ++j;
                }
            }
            File currentFile = this.convertingFile[i];
            if (this.exportBaseDir != null) {
                currentFile = new File(this.exportBaseDir, this.convertingFile[i].getName());
            }
            param.add(FileNameUtils.getChangedExtensionName(currentFile, this.extension));
            try {
                String[] arg = param.toArray(new String[0]);
                if (this.extension.equals("psp")) {
                    PSPMovieSetting[] settings = PSPMovieSettingTableViewer.toPSPMovieSettings(Akj_betasPlugin.getDefault().getPreferenceStore().getString("pspsetting.movie_settings"));
                    if (settings.length == 0) {
                        log.warn((Object)"psp setting not found");
                        return;
                    }
                    PSPFFMpegPreference preference = PSPConvertTabBuilder.toPreference(settings[0]);
                    preference.setFfmpegPath(ffmpegPath);
                    arg = preference.toCommand(this.convertingFile[i].getAbsolutePath(), null, FileNameUtils.getChangedExtensionName(currentFile, "mp4"));
                }
                this.debugArray(arg);
                this.currentProcess = runtime.exec(arg);
                monitor = new ProcessMonitor(this.currentProcess, Akj_betasPlugin.getDefault().getProcessPrinter());
                monitor.startMonitor();
                try {
                    this.currentProcess.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            monitor.stop();
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorProcess());
            ++i;
        }
        this.ffmpegExecutable.executingFile(null, -1);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorDone());
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new FinishAction());
    }

    public String fixOddSize(int w, int h) {
        String ret = "";
        if (w > 0) {
            ret = w % 2 > 0 ? String.valueOf(ret) + (w - 1) + "x" : String.valueOf(ret) + w + "x";
        } else {
            return null;
        }
        if (h > 0) {
            ret = h % 2 > 0 ? String.valueOf(ret) + (h - 1) : String.valueOf(ret) + h;
        } else {
            return null;
        }
        return ret;
    }

    public boolean isOdd(int w, int h) {
        boolean ret = false;
        if (w > 0 && w % 2 > 0) {
            return true;
        }
        if (h > 0 && h % 2 > 0) {
            return true;
        }
        return ret;
    }

    public File[] getFileList() {
        return this.convertingFile;
    }

    public FFMpegExecutable getFfmpegExecutable() {
        return this.ffmpegExecutable;
    }

    public void setFfmpegExecutable(FFMpegExecutable ffmpegExecutable) {
        this.ffmpegExecutable = ffmpegExecutable;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public File[] getConvertingFile() {
        return this.convertingFile;
    }

    public void setConvertingFile(File[] convertingFile) {
        this.convertingFile = convertingFile;
    }

    public File getExportBaseDir() {
        return this.exportBaseDir;
    }

    public void setExportBaseDir(File exportBaseDir) {
        this.exportBaseDir = exportBaseDir;
    }

    public class FinishAction
    extends Thread {
        public void run() {
            FFMpegExplorerExecuter.this.ffmpegExecutable.finishExecute();
        }
    }

    public class ConvertMonitorStartSubTask
    extends Thread {
        String name;

        public ConvertMonitorStartSubTask(String name) {
            this.name = name;
        }

        public void run() {
            if (FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor() != null) {
                FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor().subTask(this.name);
            }
        }
    }

    public class ConvertMonitorProcess
    extends Thread {
        public void run() {
            if (FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor() != null) {
                FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor().worked(1);
            }
        }
    }

    public class ConvertMonitorDone
    extends Thread {
        public void run() {
            if (FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor() != null) {
                FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor().done();
            }
        }
    }
}

