/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;

public class RoundRectangleButton
extends Figure
implements MouseMotionListener,
MouseListener {
    private String label = "";
    private int roundX = 20;
    private int roundY = 20;
    private Font font = new Font(null, "MS Mincho", 32, 0);

    public RoundRectangleButton() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void paintFigure(Graphics g) {
        g.fillRoundRectangle(this.getClientArea(), this.roundX, this.roundY);
        g.setFont(this.font);
        TextLayout textLayout = new TextLayout(null);
        textLayout.setText(this.label);
        textLayout.setWidth(this.getClientArea().width);
        textLayout.setAlignment(0x1000000);
        Rectangle rect = textLayout.getBounds();
        g.drawTextLayout(textLayout, this.getClientArea().x, this.getClientArea().y + (this.getClientArea().height - rect.height) / 2);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getRoundX() {
        return this.roundX;
    }

    public void setRoundX(int roundX) {
        this.roundX = roundX;
    }

    public int getRoundY() {
        return this.roundY;
    }

    public void setRoundY(int roundY) {
        this.roundY = roundY;
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
        this.setBorder((Border)new FocusBorder());
        this.repaint();
    }

    public void mouseExited(MouseEvent me) {
        this.setBorder(null);
        this.repaint();
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
        this.clickButton();
    }

    protected void clickButton() {
    }
}

