/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.SimpleProcessPrinter;

public final class FFMpegUtils {
    public static int[] sizeToWidthHeight(String size) {
        String[] vs = size.split("x");
        if (vs.length == 1) {
            return null;
        }
        return new int[]{Integer.parseInt(vs[0]), Integer.parseInt(vs[1])};
    }

    public static boolean isFFMpegAvailable(String path) {
        return path != null && !path.equals("") && path.endsWith("ffmpeg.exe") && new File(path).exists();
    }

    public static int getFFMpegGeneration(String path) {
        int ret;
        block7: {
            ret = 1;
            Runtime runtime = Runtime.getRuntime();
            String[] command = new String[]{path, "-formats"};
            try {
                Process process = runtime.exec(command);
                SimpleProcessPrinter printer = new SimpleProcessPrinter();
                ProcessMonitor monitor = new ProcessMonitor(process, printer);
                monitor.startMonitor();
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String formats = printer.getLog();
                String[] lines = formats.split("\n");
                String[] checks = new String[]{"libfaac", "libmp3lame", "libxvid", "libx264"};
                int j = 0;
                while (j < lines.length) {
                    int i = 0;
                    while (i < checks.length) {
                        if (lines[j].endsWith(checks[i])) {
                            ret = 2;
                            break block7;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static String toAVSScript(String path) {
        return "DirectShowSource(\"" + path + "\")";
    }

    public static boolean shouldUseAvisynth(File file) {
        String[] notsupport = new String[]{"flv", "mpg", "mp3"};
        int i = 0;
        while (i < notsupport.length) {
            if (file.getName().endsWith("." + notsupport[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAvisynthAvailable(File ffmpeg) {
        File tmp = null;
        try {
            tmp = File.createTempFile("avisynth", ".avs");
            FileWriter writer = new FileWriter(tmp);
            writer.write("BlankClip()");
            writer.close();
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(new String[]{ffmpeg.getAbsolutePath(), "-i", tmp.getAbsolutePath()});
            SimpleProcessPrinter ffmpegMonitor = new SimpleProcessPrinter();
            ProcessMonitor monitor = new ProcessMonitor(p, ffmpegMonitor);
            monitor.startMonitor();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            tmp.delete();
            String log = ffmpegMonitor.getLog();
            if (log.indexOf("Video: rawvideo") != -1) {
                return true;
            }
        }
        catch (IOException e) {
            tmp.delete();
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isProgressString(String line) {
        return line.startsWith("size=") || line.startsWith("frame=");
    }

    public static int getProgressFrame(String line) {
        int end;
        int r = 0;
        int s = line.indexOf("frame=");
        if (s != -1 && (end = line.indexOf("k", s + 5)) != -1) {
            String tmp = line.substring(s + 5, end);
            r = Integer.parseInt(tmp.replaceAll(" ", ""));
        }
        return r;
    }

    public static int getProgressSize(String line) {
        int end;
        int r = 0;
        int s = line.indexOf("size=");
        if (s != -1 && (end = line.indexOf("k", s + 5)) != -1) {
            String tmp = line.substring(s + 5, end);
            r = Integer.parseInt(tmp.replaceAll(" ", ""));
        }
        return r;
    }

    public static double timeToDouble(String duration) {
        if (duration == null) {
            return 0.0;
        }
        Pattern durationPattern = Pattern.compile("(\\d+):(\\d+):(\\d+)\\.(\\d)+$");
        long millisecond = 0L;
        Matcher match = durationPattern.matcher(duration);
        if (match.matches()) {
            int hour = Integer.parseInt(match.group(1));
            int minute = Integer.parseInt(match.group(2));
            int second = Integer.parseInt(match.group(3));
            int millis = Integer.parseInt(match.group(4));
            millisecond = hour * 60 * 60 * 1000;
            millisecond += (long)(minute * 60 * 1000);
            millisecond += (long)(second * 1000);
            return (double)(millisecond += (long)millis) / 1000.0;
        }
        return 0.0;
    }
}

