/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.imageedit.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class ClipboardUtil {
    public static BufferedImage getClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                BufferedImage text = (BufferedImage)t.getTransferData(DataFlavor.imageFlavor);
                return text;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public static boolean isSameImage(BufferedImage image1, BufferedImage image2) {
        if (image1 == null || image2 == null) {
            return false;
        }
        WritableRaster raster1 = image1.getRaster();
        WritableRaster raster2 = image2.getRaster();
        return ClipboardUtil.isSameImage(raster1, raster2);
    }

    public static boolean isSameImage(Raster raster1, Raster raster2) {
        int[] bf2;
        if (raster1 == null || raster2 == null) {
            return false;
        }
        int[] bf1 = raster1.getPixels(0, 0, raster1.getWidth(), raster1.getHeight(), (int[])null);
        if (bf1.length != (bf2 = raster2.getPixels(0, 0, raster2.getWidth(), raster2.getHeight(), (int[])null)).length) {
            return false;
        }
        int i = 0;
        while (i < bf1.length) {
            if (bf1[i] != bf2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSameImage(int[] pixels1, int[] pixels2) {
        if (pixels1 == null || pixels2 == null) {
            return false;
        }
        if (pixels1.length != pixels2.length) {
            return false;
        }
        int i = 0;
        while (i < pixels1.length) {
            if (pixels1[i] != pixels2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

