/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.imageedit.figures;

import jp.sourceforge.akjrcp.imageedit.ImageEditView;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class RectangleFigure
extends Figure
implements ImageEditView.ResizableFigure {
    private Color color = new Color(null, 200, 0, 0);
    private int resizeBoxSize = 30;
    private int minBound = 30;

    public RectangleFigure(int x, int y, int width, int height) {
        this.setSize(width, height);
        this.setLocation(new Point(x, y));
    }

    public boolean isResizeBox(Point pt) {
        Rectangle rect = new Rectangle(this.getLocation().x + this.getBounds().width - this.resizeBoxSize, this.getLocation().y + this.getBounds().height - this.resizeBoxSize, this.resizeBoxSize, this.resizeBoxSize);
        return rect.contains(pt);
    }

    public void paintFigure(Graphics g) {
        g.setForegroundColor(this.color);
        g.drawRectangle(this.getLocation().x, this.getLocation().y, this.getBounds().width - 1, this.getBounds().height - 1);
        g.drawRectangle(this.getLocation().x + this.getBounds().width - this.resizeBoxSize, this.getLocation().y + this.getBounds().height - this.resizeBoxSize, this.resizeBoxSize, this.resizeBoxSize);
    }

    public void resize(int incrementWidth, int incrementHeight) {
        this.setSize(Math.max(this.minBound, this.getBounds().width + incrementWidth), Math.max(this.minBound, this.getBounds().height + incrementHeight));
    }
}

