/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.ui.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DirectoryPathCombo
extends Composite
implements IPropertyChangeListener {
    private IPreferenceStore store;
    private String key;
    private CCombo directoryPaths;
    private SelectionListener selectionListener;
    Button openButton;
    Button explorerButton;

    public void setEnabled(boolean bool) {
        this.directoryPaths.setEnabled(bool);
        if (this.openButton != null) {
            this.openButton.setEnabled(bool);
        }
        if (this.explorerButton != null) {
            this.explorerButton.setEnabled(bool);
        }
    }

    public File getSelectedDirectory() {
        String item = this.directoryPaths.getItem(this.directoryPaths.getSelectionIndex());
        if (item.length() > 0) {
            return new File(item);
        }
        return null;
    }

    public DirectoryPathCombo(Composite parent, int style, IPreferenceStore store, String key, Image openIcon, Image explorerIcon) {
        super(parent, style);
        this.store = store;
        this.key = key;
        this.setLayout((Layout)new GridLayout(3, false));
        if (openIcon != null) {
            this.openButton = new Button((Composite)this, 0);
            this.openButton.setImage(openIcon);
            this.openButton.setToolTipText(Messages.getString("select_directory"));
            this.openButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DirectoryPathCombo.this.openDirectory();
                }
            });
        }
        this.directoryPaths = new CCombo((Composite)this, 0);
        this.directoryPaths.setLayoutData((Object)new GridData(768));
        this.updatePaths();
        if (explorerIcon != null) {
            this.explorerButton = new Button((Composite)this, 0);
            this.explorerButton.setToolTipText(Messages.getString("show_directory"));
            this.explorerButton.setImage(explorerIcon);
            this.explorerButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DirectoryPathCombo.this.explorerDirectory();
                }
            });
        }
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void explorerDirectory() {
        File file = this.getSelectedDirectory();
        if (file != null) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec(new String[]{"explorer", file.getAbsolutePath()});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void openDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        if (path != null) {
            this.openDirectory(path);
        }
    }

    public void openDirectory(String path) {
        boolean find = false;
        int i = 0;
        while (i < this.directoryPaths.getItemCount()) {
            if (this.directoryPaths.getItem(i).equals(path)) {
                this.directoryPaths.select(i);
                find = true;
                break;
            }
            ++i;
        }
        if (!find) {
            this.directoryPaths.add(path);
            this.directoryPaths.select(this.directoryPaths.getItemCount() - 1);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updatePaths();
    }

    public void updatePaths() {
        String paths = this.store.getString(this.key);
        String[] path = paths.split(";");
        String current = null;
        if (this.directoryPaths.getSelectionIndex() > -1) {
            current = this.directoryPaths.getItem(this.directoryPaths.getSelectionIndex());
        }
        this.directoryPaths.removeAll();
        int i = 0;
        while (i < path.length) {
            this.directoryPaths.add(path[i]);
            ++i;
        }
        if (this.selectionListener != null) {
            this.directoryPaths.removeSelectionListener(this.selectionListener);
        }
        if (current == null) {
            this.directoryPaths.select(0);
        } else {
            boolean find = false;
            int i2 = 0;
            while (i2 < path.length) {
                if (path[i2].equals(current)) {
                    this.directoryPaths.select(i2);
                    find = true;
                    break;
                }
                ++i2;
            }
            if (!find && current != null) {
                this.directoryPaths.add(current);
                this.directoryPaths.select(this.directoryPaths.getItemCount() - 1);
            }
        }
        if (this.selectionListener != null) {
            this.directoryPaths.addSelectionListener(this.selectionListener);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public IPreferenceStore getStore() {
        return this.store;
    }

    public void setStore(IPreferenceStore store) {
        this.store = store;
    }
}

