/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.srt;

public class TimeData {
    private int hour;
    private int second;
    private int minute;
    private int millisecond;

    public TimeData(long millisecond) {
        this.setTime(millisecond);
    }

    public void setTime(long millisecond) {
        long hour_millisecond = 3600000L;
        int minute_millisecond = 60000;
        int second_millisecond = 1000;
        int hour = (int)(millisecond / hour_millisecond);
        long remain = millisecond % hour_millisecond;
        int minute = (int)(remain / (long)minute_millisecond);
        int second = (int)((remain %= (long)minute_millisecond) / (long)second_millisecond);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond((int)(remain %= (long)second_millisecond));
    }

    public TimeData(String line) {
        int hour = Integer.parseInt(line.substring(0, 2));
        int minute = Integer.parseInt(line.substring(3, 5));
        int second = Integer.parseInt(line.substring(6, 8));
        int milli = Integer.parseInt(line.substring(9, 12));
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(milli);
    }

    public long getTime() {
        long result = this.millisecond;
        result += (long)(this.second * 1000);
        result += (long)(this.minute * 60 * 1000);
        return result += (long)(this.hour * 60 * 60 * 1000);
    }

    public String toString() {
        return String.valueOf(this.toLabel2(this.hour)) + ":" + this.toLabel2(this.minute) + ":" + this.toLabel2(this.second) + "," + this.toLabel3(this.millisecond);
    }

    public String toLabel2(int number) {
        String v = "" + number;
        if (v.length() < 2) {
            v = "0" + v;
        }
        return v;
    }

    public String toLabel3(int number) {
        String v = "" + number;
        if (v.length() < 2) {
            v = "0" + v;
        }
        if (v.length() < 3) {
            v = "0" + v;
        }
        if (v.length() > 3) {
            return "999";
        }
        return v;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setHour(int i) {
        this.hour = i;
    }

    public void setMillisecond(int i) {
        this.millisecond = i;
    }

    public void setMinute(int i) {
        this.minute = i;
    }

    public void setSecond(int i) {
        this.second = i;
    }

    public synchronized void roll(long duration) {
        long current = this.getTime();
        this.setTime(current += duration);
    }
}

