/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.sub;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.sub.SUBObject;
import org.apache.commons.lang.SystemUtils;

public class SUBList {
    private String baseDir;
    private double frameRate = 29.97;
    private List subDatas = new Vector();

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public void addSubData(SUBObject data) {
        this.subDatas.add(data);
    }

    public SUBObject[] getSubOjects() {
        return this.subDatas.toArray(new SUBObject[this.subDatas.size()]);
    }

    public long getFrameTime(int frame) {
        long result = -1L;
        result = (long)((double)((long)frame * 1000L) / this.frameRate);
        return result;
    }

    public String toString() {
        String result = "basedir=" + this.baseDir + ",frameRate=" + this.frameRate + SystemUtils.LINE_SEPARATOR;
        SUBObject[] datas = this.getSubOjects();
        int i = 0;
        while (i < datas.length) {
            result = String.valueOf(result) + datas[i].toString() + SystemUtils.LINE_SEPARATOR;
            ++i;
        }
        return result;
    }

    public long getTotalTime() {
        long result = 0L;
        SUBObject[] datas = this.getSubOjects();
        int i = 0;
        while (i < datas.length) {
            result += (long)datas[i].getBetweenFrame();
            ++i;
        }
        return result;
    }

    public List getSubDataList() {
        Vector<StandardSubObject> list = new Vector<StandardSubObject>();
        int i = 0;
        while (i < this.subDatas.size()) {
            SUBObject subobject = (SUBObject)this.subDatas.get(i);
            StandardSubObject standard = new StandardSubObject();
            standard.setStartTime(this.getFrameTime(subobject.getStartFrame()));
            standard.setEndTime(this.getFrameTime(subobject.getEndFrame()));
            standard.setImagePath(subobject.getText());
            list.add(standard);
            ++i;
        }
        return list;
    }
}

