/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.effect;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.VideoSystem;
import jp.sourceforge.akjrcp.text_douga.effect.FillImageEffect;

public class FrameImageEffect
extends FillImageEffect {
    @Override
    public String toString() {
        String out = "FrameImageEffect: " + super.toString();
        return out;
    }

    public FrameImageEffect(boolean effectBefore, double effectTime) {
        this.fullPaintTime = 0.0;
        if (effectBefore) {
            this.setBeforeTime(effectTime);
            this.setAfterTime(0.0);
        } else {
            this.setBeforeTime(0.0);
            this.setAfterTime(effectTime);
        }
    }

    public void loadImage(int frame) throws IOException {
        if (this.image == null) {
            if (frame < 0) {
                log.warn((Object)"keyframe is under 0");
                return;
            }
            String imgPath = VideoSystem.getFrameFilePath(this.getExportDir(), frame);
            File file = new File(imgPath);
            if (file.exists()) {
                this.image = ImageIO.read(file);
            }
        }
    }

    @Override
    public void effectKeyFrame(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        if (this.getAfterTime() > 0.0) {
            this.loadImage(this.getKeyFrame() - 1);
            super.effectAfter(preference, baseImage, frame, time);
        }
    }

    @Override
    public void effectBefore(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        this.loadImage(this.getKeyFrame());
        super.effectBefore(preference, baseImage, frame, time);
    }

    @Override
    public void effectAfter(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        this.loadImage(this.getKeyFrame() - 1);
        super.effectAfter(preference, baseImage, frame, time);
    }
}

