/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.Messages;
import jp.sourceforge.akjrcp.text_douga.SystemEnvironment;
import jp.sourceforge.akjrcp.text_douga.item.AbstractItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageItem
extends AbstractItem {
    public static Log log = LogFactory.getLog(ImageItem.class);
    protected String inputPath;

    @Override
    public String toString() {
        return "ImageItem:" + super.toString() + " inputPath=" + this.inputPath;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public boolean writeFrame(DougaPreference preference, ImageObject baseImage, int frame) throws IOException {
        boolean written = false;
        if (this.duration == -1.0) {
            written = true;
        }
        double frameTime = this.getFrameTime(frame, preference.getFps());
        if (!written) {
            written = this.isInFrame(preference, frame);
        }
        if (written) {
            Rectangle drawRect = this.getDrawRect(preference, frameTime);
            BufferedImage img = SystemEnvironment.getSystemEnvironment().getImageCasher().loadImage(this.inputPath);
            log.trace((Object)drawRect);
            if (img == null) {
                log.warn((Object)("img null:" + this.inputPath));
                DougaSystem.dougaLogger.info(String.valueOf(Messages.getString("log.load_faild")) + ":" + this.inputPath);
                throw new IOException("load image faild:");
            }
            log.trace((Object)(String.valueOf(img.getWidth()) + "x" + img.getHeight()));
            Graphics2D g2 = (Graphics2D)baseImage.getImage().getGraphics();
            float tp = this.getFrameTransparent(preference, frameTime);
            log.trace((Object)("transparent=" + tp));
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setComposite(AlphaComposite.getInstance(3, tp));
            int mx = this.getMovedX(preference, frameTime);
            int my = this.getMovedY(preference, frameTime);
            g2.drawImage(img, drawRect.x + mx, drawRect.y + my, drawRect.x + mx + drawRect.width, drawRect.y + my + drawRect.height, 0, 0, img.getWidth(), img.getHeight(), null);
        }
        return written;
    }

    public Rectangle getDrawRect(DougaPreference preference, double currentTime) {
        BufferedImage img = SystemEnvironment.getSystemEnvironment().getImageCasher().loadImage(this.inputPath);
        if (img == null) {
            log.warn((Object)"img is null");
            return null;
        }
        int dw = this.width;
        int dh = this.height;
        if (dw != 0 && dh != 0 && this.keepAspect) {
            double haspect;
            double waspect = (double)dw / (double)img.getWidth();
            if (waspect > (haspect = (double)dh / (double)img.getHeight())) {
                dw = (int)((double)img.getWidth() * haspect);
            } else {
                dh = (int)((double)img.getHeight() * waspect);
            }
        }
        if (dw == 0) {
            dw = img.getWidth();
        }
        if (dh == 0) {
            dh = img.getHeight();
        }
        dw += this.getMovedWidth(preference, currentTime);
        dh += this.getMovedHeight(preference, currentTime);
        dw = Math.max(1, dw);
        dh = Math.max(1, dh);
        int dx = 0;
        if (this.align == 0) {
            dx = this.x;
        } else if (this.align == 1) {
            dx = 0;
        } else if (this.align == 3) {
            dx = preference.getWidth() - dw;
        } else if (this.align == 2) {
            dx = (preference.getWidth() - dw) / 2;
        } else {
            log.warn((Object)("invalid align:" + this.align));
        }
        int dy = 0;
        if (this.valign == 0) {
            dy = this.y;
        } else if (this.valign == 1) {
            dy = 0;
        } else if (this.valign == 3) {
            dy = preference.getHeight() - dh;
        } else if (this.valign == 2) {
            dy = (preference.getHeight() - dh) / 2;
        } else {
            log.warn((Object)("invalid valign:" + this.valign));
        }
        return new Rectangle(dx, dy, dw, dh);
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }
}

