/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.video;

import java.io.IOException;
import java.math.BigDecimal;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegJpegPipeReader;
import jp.sourceforge.akjrcp.ffmpeg.JpegPipeReader;
import jp.sourceforge.akjrcp.ffmpeg.ProcessListener;
import jp.sourceforge.akjrcp.text_douga.video.JpegKeeper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VideoImageInput
implements ProcessListener {
    public static Log log = LogFactory.getLog(VideoImageInput.class);
    private double fps = 30.0;
    private int width = 640;
    private int height = 480;
    public static final int NOT_SPECIFIED = -1;
    private String ffmpegPath;
    private String inputPath;
    private double startTime;
    private double duration = -1.0;
    private boolean copying;
    private boolean canceling;
    private FFMpegJpegPipeReader ffreader;
    private JpegPipeReader pipeReader;
    private JpegKeeper jpegKeeper;

    public VideoImageInput(String ffmpegPath, String inputPath) throws IOException {
        this(ffmpegPath, inputPath, 0.0, -1.0);
    }

    public VideoImageInput(String ffmpegPath, String inputPath, double start, double duration) throws IOException {
        this.ffmpegPath = ffmpegPath;
        this.inputPath = inputPath;
        this.startTime = start;
        this.duration = duration;
        this.pipeReader = new JpegPipeReader();
        this.jpegKeeper = new JpegKeeper();
    }

    public void startInput() {
        this.ffreader = new FFMpegJpegPipeReader(this.ffmpegPath, this.inputPath, new String[]{"-r", "" + this.fps, "-s", String.valueOf(this.width) + "x" + this.height});
        this.ffreader.setProcessPrinter(null);
        this.ffreader.setJpegPipeReader(this.pipeReader);
        Thread t = new Thread((Runnable)this.ffreader);
        this.ffreader.setProcessListener((ProcessListener)this);
        t.start();
        this.copying = true;
    }

    public void finished() {
        this.copying = false;
        log.info((Object)"done");
    }

    public void started() {
        byte[] jpegData;
        int index = 1;
        log.info((Object)"started");
        int skipFrame = 0;
        if (this.startTime > 0.0) {
            double fps_time = this.fps * this.startTime;
            BigDecimal dec = new BigDecimal(fps_time);
            skipFrame = dec.setScale(0, 4).intValue();
            log.info((Object)("fps_time=" + fps_time + " skipFrame=" + skipFrame));
        }
        int i = 0;
        while (i < skipFrame) {
            jpegData = this.pipeReader.nextImage();
            if (jpegData == null) {
                this.jpegKeeper.setFinished(true);
                this.copying = false;
                return;
            }
            ++i;
        }
        log.info((Object)("skipped:" + skipFrame));
        int durationFrame = 0;
        if (this.duration > 0.0) {
            double duration_time = this.fps * this.duration;
            BigDecimal dec = new BigDecimal(duration_time);
            durationFrame = dec.setScale(0, 4).intValue();
            log.info((Object)("fps_time=" + duration_time + " skipFrame=" + durationFrame));
        }
        int writeFrame = 0;
        while ((jpegData = this.pipeReader.nextImage()) != null) {
            if (this.canceling) break;
            log.trace((Object)"add");
            this.jpegKeeper.addImage(jpegData);
            ++index;
            if (++writeFrame != durationFrame) continue;
            try {
                this.pipeReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break;
        }
        log.info((Object)("writeFrame=" + writeFrame + ",durationFrame=" + durationFrame));
        if (this.canceling) {
            try {
                this.pipeReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info((Object)("vfinished: writed=" + writeFrame));
        this.jpegKeeper.setFinished(true);
        this.copying = false;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.ffreader.getProcess().destroy();
    }

    public boolean isCanceling() {
        return this.canceling;
    }

    public void setCanceling(boolean canceling) {
        this.canceling = canceling;
    }

    public boolean isCopying() {
        return this.copying;
    }

    public void setCopying(boolean copying) {
        this.copying = copying;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public JpegKeeper getJpegKeeper() {
        return this.jpegKeeper;
    }

    public void setJpegKeeper(JpegKeeper jpegKeeper) {
        this.jpegKeeper = jpegKeeper;
    }

    public double getFps() {
        return this.fps;
    }

    public void setFps(double fps) {
        this.fps = fps;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

