package tk.stepcounter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

import tk.stepcounter.format.*;

/** R}hC̋NNX */
public class Main {
	
	private File[] files;
	private ResultFormatter formatter;
	private PrintStream output = System.out;;

	private long allStep;
	private long allNon;
	private long allComment;
	
	/** t@CZbg܂ */
	public void setFiles(File[] files){
		this.files = files;
	}
	
	/** tH[}b^Zbg܂B */
	public void setFormatter(ResultFormatter formatter){
		this.formatter = formatter;
	}
	
	/** o̓Xg[ݒ肵܂B */
	public void setOutput(PrintStream output){
		this.output = output;
	}
	
	/** JEgs܂ */
	public void executeCount() throws IOException {
		// tH[}b^ݒ肳ĂȂꍇ̓ftHggp
		if(formatter==null){
			formatter = FormatterFactory.getFormatter("");
		}
		// Pt@C or PfBNgJEg
		ArrayList list = new ArrayList();
		for(int i=0;i<files.length;i++){
			CountResult[] results = count(files[i]);
			for(int j=0;j<results.length;j++){
				list.add(results[j]);
			}
		}
		CountResult[] results = (CountResult[])list.toArray(new CountResult[list.size()]);
		output.println(formatter.format(results));
		output.flush();
		output.close();
	}
	
	/** Pt@CJEg */
	private CountResult[] count(File file) throws IOException {
		if(file.isDirectory()){
			File[] files = file.listFiles();
			ArrayList list = new ArrayList();
			for(int i=0;i<files.length;i++){
				CountResult[] results = count(files[i]);
				for(int j=0;j<results.length;j++){
					list.add(results[j]);
				}
			}
			return (CountResult[])list.toArray(new CountResult[list.size()]);
		} else {
			StepCounter counter = StepCounterFactory.getCounter(file.getName());
			if(counter!=null){
				CountResult result = counter.count(file);
				return new CountResult[]{result};
			} else {
				// Ή̌`̏ꍇ͌`nullݒ肵ĕԂ
				return new CountResult[]{
					new CountResult(file.getName(),null,0,0,0)
				};
			}
		}
	}
	
	/** R}hCNp\bh */
	public static void main(String[] args) throws IOException {
		
		if(args==null || args.length==0){
			System.exit(0);
		}
		String format = null;
		String output = null;
		ArrayList fileList = new ArrayList();
		for(int i=0;i<args.length;i++){
			if(args[i].startsWith("-format=")){
				String[] dim = Util.split(args[i],"=");
				format = dim[1];
			} else if(args[i].startsWith("-output=")){
				String[] dim = Util.split(args[i],"=");
				output = dim[1];
			} else {
				fileList.add(new File(args[i]));
			}
		}
		
		Main main = new Main();
		main.setFiles((File[])fileList.toArray(new File[fileList.size()]));
		main.setFormatter(FormatterFactory.getFormatter(format));
		if(output!=null && !output.equals("")){
			main.setOutput(new PrintStream(new FileOutputStream(new File(output))));
		}
		
		main.executeCount();
	}
	
}