require 'epcb/win32ole-ext'
require 'csv'
require 'parsedate'
require 'fileutils'

module EPCB
  # exit codes
  CODE_OK = 0
  CODE_ARGUMENT_ERROR = 110
  CODE_IO_ERROR = 120
  CODE_FILE_NOT_FOUND = 121
  CODE_UNEXPECTED_ERROR = 255

  # TuR}h
  SUBC_CSV = "gencsv"
  SUBC_EXCEL = "genexcel"
  SUBC_ALL = "genall"
  
  # CSṼV[gɂvtBbNX
  CSV_SHEET_PREFIX = "$$"
  #CSV_COL_SEP = ?,
  CSV_LINE_SEP = "\r\n"

  # --verbosew莞ɃbZ[Wo͂B
  def vout(message)
    print("#{message}") if $options.verbose
  end

  def voutln(message = "")
    EPCB::vout("#{message}\n")
  end

  # G[bZ[Wo͂B
  def eout(message)
    $stderr.print("[error] #{message}")
  end

  def eoutln(message = "")
    EPCB::eout("#{message}\n")
  end

  # "t@CȂ"Ƃ|̃G[bZ[WƋFileNotFoundErrorraiseB
  def file_not_found(file)
    raise(FileNotFoundError, "File \"#{file}\" not found.")
  end

  # versionɑΉVersionSpecificFunctioñCX^X𐶐B
  def new_function(prefix, version, excel_util)
    instance = nil
    begin
      instance = eval("#{prefix}#{version}").new(excel_util)
    rescue Exception
      return nil
    end
    return instance
  end

  # x.y.z ̃o[W x.y ̕ԂB
  def truncate_minor2(version)
    return nil if version.nil?
    if /^(\d+)\.(\d+)\.(\d+)$/ =~ version
      return "#{$1}.#{$2}"
    end
    return version
  end

  module_function :vout, :voutln, :eout, :eoutln, :file_not_found, \
  :new_function, :truncate_minor2

  class FileNotFoundError < IOError ; end

  # IvVȂꍇ̃G[B
  class OptionUnsatisfiedError < Exception ; end

  # w肳ꂽo[Ŵ̂ꍇ̃G[B
  class UnknownVersionError < Exception ; end

  # R}hC̃TuR}hɑNXB
  # ʂɃNXȂĂB
  class Subcommand
    attr_reader :command, :klass
    def initialize(command, klass)
      @command = command
      @klass = klass
    end
  end # class Subcommand #

  # Excel֘Ã[eBeBNX
  class ExcelUtil
    attr_reader :excel

    def initialize()
      @excel = nil
    end

    public
    def self.to_yyyymmdd_format(date_str, sep = "/")
      if date_str.nil? || date_str.empty?
        return nil
      end
      d = ParseDate.parsedate(date_str)
      return "#{d[0]}#{sep}#{d[1]}#{sep}#{d[2]}"
    end

    def new_excel
      if @excel.nil?
        @excel = Excel.new(true, true)
      end
      return @excel
    end

    def destroy_excel
      unless @excel.nil?
        @excel.quit
        @excel = nil
      end
    end

    def open_workbook_and_activate(path)
      workbook = @excel.workbooks.open(path)
      workbook.activate
      return workbook
    end

    def is_valid_data_sheet_name(name)
      return @excel.run("IsValidDataSheetName", name)
    end

    def initialize_on_active_sheet()
      @excel.run("Initialize")
    end

    def get_offset(line, column)
      return @excel.run("GetOffset", line, column)
    end

    # ExcelPettyCashBook̃o[WJg[NubN擾B
    def version_from_workbook
      begin
        return @excel.run("Const_VERSION")
      rescue WIN32OLERuntimeError => e
        return nil
      end
    end
  end # class ExcelUtil #

  # t@C𐶐NXB
  class Generator
    attr_reader :src_path, :dest_path

    def initialize
      @src_path = nil
      @dest_path = nil
      @util = ExcelUtil.new
      @function = nil
    end

    # ɕKvȑOsB
    def setup(src_file, dest_file = nil)
      EPCB::file_not_found(src_file) unless FileTest.exist?(src_file)
      @src_path = File.file_system.getAbsolutePathName(src_file)
      EPCB::voutln("src_path = #{@src_path}")

      return if dest_file.nil?
      @dest_path = File.file_system.getAbsolutePathName(dest_file)
      EPCB::voutln("dest_path = #{@dest_path}")
    end

    # 炩̃t@C𐶐BTuNXŃI[oChB
    def execute ; end
    
    # ㏈s\bhB
    def destroy
      @util.destroy_excel unless @util.nil?
    end
  end # class Generator #

  # ̍𖄂߂邽߂̃NXBo[WɓL̋@\ǉꍇ
  # TuNX쐬ĎB
  class VersionSpecificFunction
    def initialize(excel_util)
      @util = excel_util
      @constants_cache = Hash.new
    end

    def const_of(name)
      value = @constants_cache[name]
      if value.nil?
        value = @util.excel.run("Const_#{name}")
        @constants_cache[name] = value
      end
      return value
    end

    def master_sheet?(name)
      return $options.master && const_of("MASTER_SHEET_NAME") == name
    end
  end # VersionSpecificFunction #

  class VersionSpecificReaderFunction < VersionSpecificFunction
    def on_each_sheet(sheet, dest_file)
      EPCB::voutln("Processing sheet \"#{sheet.name}\"")
      sheet.activate
      @util.initialize_on_active_sheet
      # V[go
      CSV::Writer.generate(dest_file, ?,, EPCB::CSV_LINE_SEP) do |csv|
        csv << [ EPCB::CSV_SHEET_PREFIX + sheet.name ]
      end
      for i in 0 .. const_of("MAX_DATA_LINE")
        break if is_empty_line_continued_to_limit(i)
        # ef[^sTuNX̃\bhĂ
        on_each_data_line(i, dest_file)
      end
      EPCB::voutln("Finished sheet \"#{sheet.name}\"\n")
    end

    def on_master_sheet(sheet, dest_file)
      EPCB::voutln("Processing master sheet.")
      sheet.activate
      CSV::Writer.generate(dest_file, ?,, EPCB::CSV_LINE_SEP) do |csv|
        csv << [ EPCB::CSV_SHEET_PREFIX + sheet.name ]
      end
    end

    protected
    def on_each_data_line(line, dest_file)
      data = get_column_data(line)
      # f[^so
      CSV::Writer.generate(dest_file, ?,, EPCB::CSV_LINE_SEP) do |csv|
        EPCB::voutln("row[#{line}] = [#{data.join(",")}]")
        csv << data
      end
    end

    def get_column_data(line) ; end
    def is_empty_line_continued_to_limit(line) ; end
  end # class VersionSpecificReaderFunction #

  class VersionSpecificWriterFunction < VersionSpecificFunction
    # CSVt@CJꂽɌĂяoB̎_workbookJĂ̂ŁA
    # }Ngp\łB
    def on_csv_file(file, workbook) ; end

    protected
    # CSVt@C̊esۂɌĂяoB
    def on_each_csv_row(row, sheet) ; end
  end # class VersionSpecificWriterFunction #

end
