require 'epcb/csv/common'

module EPCB

  # ExcelPettyCashBookf[^zグCSVo͂NXB
  class CSVGenerator < Generator
    def setup(src_file, dest_file = nil)
      super(src_file, dest_file)

      if dest_file.nil?
        # \[Xt@Co͐t@C߂
        name = File.basename(src_file, ".*")
        @dest_path = File.file_system.getAbsolutePathName("#{name}.csv")
        EPCB::voutln("dest_path = #{@dest_path}")
      end
    end

    def execute
      excel = @util.new_excel
      workbook = @util.open_workbook_and_activate(@src_path)
      @function = get_reader_function
      EPCB::voutln("function = #{@function.inspect}\n")

      File.open(@dest_path, "wb") do |dest_file|
        for i in 1 .. workbook.worksheets.count
          sheet = workbook.worksheets(i)
          # f[^V[g̏ꍇ
          if @util.is_valid_data_sheet_name(sheet.name)
            @function.on_each_sheet(sheet, dest_file)
          # "}X^"V[g̏ꍇ
          elsif @function.master_sheet?(sheet.name)
            @function.on_master_sheet(sheet, dest_file)
          end
        end
      end
    end

    private
    def get_reader_function
      ver = nil
      if $options.source_version.nil?
        # ExcelPettyCashBook̃}No[W擾
        ver = @util.version_from_workbook
        if ver.nil?
          ver = "1_0"
        else
          ver = EPCB::truncate_minor2(ver)
        end
      else
        ver = $options.source_version
      end
      ver = ver.gsub(/\./, "_")
      EPCB::voutln("source version = #{ver}")

      instance = EPCB::new_function("VersionSpecificReaderFunction_",
                                    ver, @util)
      if instance.nil? && $options.source_version != nil
        raise(UnknownVersionError,
              "Unknown source version \"#{$options.source_version}\".")
      end
      return instance
    end

  end # class CSVGenerator #

  # 1.0.x ǂݍݗp
  class VersionSpecificReaderFunction_1_0 < VersionSpecificReaderFunction
    def const_of(name)
      value = @constants_cache[name]
      return value unless value.nil?

      case name
      when "VERSION"
        value = "1.0.0"
      when "DEFAULT_BASE_LOCATION"
        value = "A7"
      when "MAX_DATA_LINE"
        value = 400
      when "TEMPLATE_SHEET_NAME"
        value = "^"
      when "MASTER_SHEET_NAME"
        value = "}X^"
      when "DATE_OFFSET"
        value = 0
      when "DAY_OF_WEEK_OFFSET"
        value = 1
      when "USE_OFFSET"
        value = 2
      when "AMOUNT_OF_MONEY_OFFSET"
        value = 3
      else
        return nil
      end
      @constants_cache[name] = value
      return value
    end

    def on_master_sheet(sheet, dest_file)
      super(sheet, dest_file)
      
      data = Array.new
      # pr}X^
      for i in 1 .. const_of("MAX_DATA_LINE")
        # cellsCells(s, )
        value = sheet.cells(i, 1).value
        # 3sȏ󂾂珈𔲂
        if value.nil?
          empty = true
          for j in 2 .. 3
            unless sheet.cells(i + j, 1).value.nil?
              empty = false
              break
            end
          end
          break if empty
          value = ""
        end

        data.push(value)
      end
      EPCB::voutln("Master = #{data.inspect}")
      CSV::Writer.generate(dest_file, ?,, EPCB::CSV_LINE_SEP) do |csv|
        csv << data
      end
      EPCB::voutln("Finished master sheet.")
    end

    protected
    def get_column_data(line)
      # t
      date = @util.get_offset(line, const_of("DATE_OFFSET")).value
      # YYYY/MM/DDɕϊ
      date = ExcelUtil.to_yyyymmdd_format(date)

      # pr
      uses = @util.get_offset(line, const_of("USE_OFFSET")).value
      # z
      amount = @util.get_offset(line, const_of("AMOUNT_OF_MONEY_OFFSET")).value
      amount = amount.truncate if amount != nil

      return [ date, uses, amount, nil ]
    end

    def is_empty_line_continued_to_limit(line)
      if @util.excel.run("IsEmptyLineContinuedToLimit", line) &&
          @util.get_offset(line, const_of("DATE_OFFSET")).value.nil?
        return true
      end
    end
  end # class VersionSpecificReaderFunction_1_0 #

  # 1.1.x ǂݍݗp
  class VersionSpecificReaderFunction_1_1 < VersionSpecificReaderFunction_1_0
    def const_of(name)
      value = @constants_cache[name]
      if value.nil?
        value = @util.excel.run("Const_#{name}")
        @constants_cache[name] = value
      end
      return value
    end

    protected
    def get_column_data(line)
      data = super(line)
      data[3] = @util.get_offset(line, const_of("NOTE_OFFSET")).value
      return data
    end
  end # class VersionSpecificReaderFunction_1_1 #

end
