require 'epcb/csv/common'

module EPCB

  # CSVf[^zグExcelPettyCashBooko͂NXB
  class ExcelGenerator < Generator
    def initialize
      super()
      @template_path = nil
    end

    def setup(src_file, dest_file = nil)
      super(src_file, dest_file)
      if $options.template.nil?
        raise(OptionUnsatisfiedError,
              "Must specify --template option" \
              " for subcommand \"genexcel\" or \"genall\".")
      elsif !FileTest.exist?($options.template)
        EPCB::file_not_found($options.template)
      end
      @template_path = File.file_system.getAbsolutePathName($options.template)

      if dest_file.nil?
        # \[Xt@Co͐t@C߂
        # pXK: <JgfBNg>\_<l>_<\[Xt@C>.xls
        prefix = "#{Dir::pwd}/_"
        for i in 1 .. 50000
          path = "#{prefix}#{i.to_s}_#{File.basename(@src_path, ".*")}.xls"
          EPCB::voutln("Created path = #{path}")
          break unless FileTest.exist?(path)
        end
        @dest_path = File.file_system.getAbsolutePathName(path)
        EPCB::voutln("dest_path = #{@dest_path}")
      end
      EPCB::voutln("template_path = #{@template_path}")
      FileUtils.cp(@template_path, @dest_path, :verbose => $options.verbose)
    end
    
    def execute
      super()

      excel = @util.new_excel
      workbook = @util.open_workbook_and_activate(@dest_path)
      @function = get_writer_function
      EPCB::voutln
      File.open(@src_path, "rb") do |file|
        @function.on_csv_file(file, workbook)
      end
    end

    private
    def get_writer_function
      ver = @util.version_from_workbook
      ver = "1.1.0" if ver.nil?
      ver = EPCB::truncate_minor2(ver)
      ver.gsub!(/\./, "_")
      EPCB::voutln("output version = #{ver}")
      return EPCB::new_function("VersionSpecificWriterFunction_",
                                ver, @util)
    end

  end # class ExcelGenerator #

  # 1.1.xo͗p
  class VersionSpecificWriterFunction_1_1 < VersionSpecificWriterFunction
    def initialize(excel_util)
      super(excel_util)
      @line_pos = 0
      @offsets = nil
    end

    def on_csv_file(file, workbook)
      @offsets = [
        const_of("DATE_OFFSET").to_i,
        const_of("USE_OFFSET").to_i,
        const_of("AMOUNT_OF_MONEY_OFFSET").to_i,
        const_of("NOTE_OFFSET").to_i,
      ]
      @line_pos = 0
      sheet = nil
      file.each do |line|
        row = CSV.parse_line(line, ?,, EPCB::CSV_LINE_SEP)
        EPCB::voutln("#{row.inspect}")
        # VV[gɐ؂ւꍇ
        if row[0] != nil && /^\$\$(.+)/ =~ row[0].to_s
          name = $1
          EPCB::voutln("Sheet \"#{name}\" found.")
          # f[^V[g̏ꍇ
          unless master_sheet?(name)
            #next unless @util.is_valid_data_sheet_name(name)
            sheet = @util.excel.run("CreateNewDataSheet", name, false)
            if sheet.nil?
              EPCB::eoutln("Couldn't create sheet \"#{name}\"." \
                           " but the process will go on.")
              next
            end
            EPCB::voutln("Created sheet \"#{sheet.name}\"")
            # V[gANeBuɂInitialize}NĂ
            sheet.activate
            @util.initialize_on_active_sheet
          # "}X^"V[g̏ꍇ
          else
            sheet = master_sheet(workbook)
            # ExcelPettyCashBook"}X^"V[gȂꍇ
            if sheet.nil?
              EPCB::voutln("Master sheet not found.")
              next
            end
          end
          @line_pos = 0
        else
          next if sheet.nil?
          on_each_csv_row(row, sheet)
        end
      end
      
      # Sf[^V[g̃f[^vZ
      @util.excel.run("CalculateAllForEverySheet")
      workbook.save
    end

    def on_each_csv_row(row, sheet)
      unless master_sheet?(sheet.name)
        # Excel̊eZɒl
        for i in 0 .. row.size
          next if row[i].nil?
          EPCB::vout("get_offset(#{@line_pos}, #{@offsets[i]}) ")
          @util.get_offset(@line_pos, @offsets[i]).value = row[i].to_s
        end
        EPCB::voutln
        @line_pos = @line_pos + 1
      else
        for i in 0 .. row.size - 1
          #EPCB::vout("cells(#{i+1}, 1) ")
          sheet.cells(i + 1, 1).value = row[i].to_s
        end
        EPCB::voutln
        # ڍst@C̃}X^f[^󕶎ŏ㏑
        for i in row.size + 1 .. const_of("MAX_DATA_LINE")
          sheet.cells(i, 1).value = ""
        end
        EPCB::voutln("Updated master \"#{row[0].to_s}\".")
      end
    end

    private
    def master_sheet(workbook)
      for i in 1 .. workbook.worksheets.count
        s = workbook.worksheets(i) 
        return s if master_sheet?(s.name)
      end
      return nil
    end
  end # class VersionSpecificWriterFunction_1_1 #

end
