#
# == cli
# R}hCAvP[Vɋʂȋ@\񋟂B
#
# Revision:: $Id$
#

#require 'optparse'

module CLI
  # R}h̏IXe[^X
  class ExitStatus
    # ɏI
    OK = 0
    # R}hCɊԈႢ┲
    ARGUMENT_ERROR = 110
    # IvV̎w肪Ȃ
    OPTION_UNSATISFIED = 111
    # IOG[
    IO_ERROR = 120
    # w肳ꂽt@C݂Ȃ
    FILE_NOT_FOUND = 121
    # w肳ꂽfBNg݂Ȃ
    DIR_NOT_FOUND = 122
    # w肳ꂽt@C̓fBNg
    FILE_IS_DIR = 123
    # w肳ꂽfBNg̓fBNgł͂Ȃ
    FILE_IS_NOT_DIR = 124
    # m̃G[
    UNEXPECTED_ERROR = 255
  end #ExitStatus#

  #
  # R}hCG[NXB
  #
  class CLIError < StandardError
    attr_reader :code

    def initialize(message, code = ExitStatus::UNEXPECTED_ERROR)
      super(message)
      @code = code
    end
  end #CLIError#

  # "t@CfBNg"̎|̃G[bZ[WƋCLIErrorraiseB
  # === ARGS
  # path:: G[ɂȂpX
  def file_is_dir(path)
    raise(CLIError.new("\"#{path}\" is directory.",
                       ExitStatus::FILE_IS_DIR))
  end

  # "t@CfBNgł͂Ȃ"̎|̃G[bZ[WƋCLIErrorraiseB
  # === ARGS
  # path:: G[ɂȂpX
  def file_is_not_dir(path)
    raise(CLIError.new("\"#{path} is not directory.",
                       ExitStatus::FILE_IS_NOT_DIR))
  end

  # "t@CȂ"Ƃ|̃G[bZ[WƋCLIErrorraiseB
  # === ARGS
  # file:: G[ɂȂpX
  def file_not_found(file)
    raise(CLIError.new("File \"#{file}\" not found.",
                       ExitStatus::FILE_NOT_FOUND))
  end

  # "fBNgȂ"Ƃ|̃G[bZ[WƋCLIErrorraiseB
  # === ARGS
  # dir:: G[ɂȂpX
  def dir_not_found(dir)
    raise(CLIError.new("Directory \"#{dir}\" not found.",
                       ExitStatus::DIR_NOT_FOUND))
  end

  # t@C݂邱ƂmFB
  # t@C݂ȂꍇCLIErrorraiseB
  # === ARGS
  # file:: ׂt@C̃pX
  def ensure_file_exist(file)
    if FileTest.directory?(file)
      file_is_dir(file)
    elsif !FileTest.exist?(file)
      file_not_found(file)
    end
  end

  # fBNg݂邱ƂmFB
  # fBNg݂ȂꍇCLIErrorraiseB
  # === ARGS
  # dir:: ׂfBNg̃pX
  def ensure_dir_exist(dir)
    if !FileTest.exist?(dir)
      directory_not_found(dir)
    elsif !FileTest.directory?(dir)
      file_is_not_dir(dir)
    end
  end

  # O+e+̃obNg[XWG[o͂ɏo͂B
  # === ARGS
  # e:: O
  def print_backtrace(e, insert_new_line = true)
    $stderr.puts("") if insert_new_line
    $stderr.puts(e.inspect)
    e.backtrace.each do |s|
      $stderr.puts("    #{s}")
    end
  end

  # ̗ÕbZ[WWG[o͂ɏo͂B
  # === ARGS
  # e:: O
  def report_error(e)
    eoutln(e.message)
  end

  # vIG[񍐂B
  # ̗ÕbZ[WƃobNg[XWG[o͂ɏo͂B
  # === ARGS
  # e:: O
  def report_fatal_error(e)
    report_error(e.message)
    $stderr.puts("")
    print_backtrace(e)
  end

  module_function :file_not_found, \
  :dir_not_found, :file_is_dir, :file_is_not_dir, :ensure_file_exist, \
  :ensure_dir_exist,  :report_error, :print_backtrace, :report_fatal_error

  #
  # R}hCAvP[V̊NXB
  #
  class Application
    def initialize
    end

    def run
    end

    def destroy
    end
  end #Application#

end #CLI#
