#
# == config/config
#
# Revision:: $Id$
#

module Config

  class ConfigError < StandardError
    attr_reader :list
    
    def initialize(message, list, file_path)
      super(message)
      @list = list
      @file_path = file_path
    end

    def to_str
      s = super.to_str
      s += ": #{@file_path}" if @file_path != nil
      @list.each do |e|
        s += "#{e.error_line}: #{e.message}\n"
      end
      #s.chop!
      return s
    end
  end #ConfigError#

  #
  # ݒt@C̒gꍇ̃G[B
  #
  class ConfigFormatError < ConfigError
    attr_reader :error_line
    
    # RXgN^
    # === ARGS
    # message:: G[bZ[W
    # line:: G[ƂȂݒXg[̍sԍ
    def initialize(message, line)
      super(message)
      @error_line = line
    end

  end #ConfigFormatError#

  module Validator
    attr_accessor :file_path, :line
    
    def initialize_validator
      @line = nil
    end

    def validate_key_value
    end
  end

  #
  # ȂValidator
  # 
  class NullValidator
    include Validator
    
    def initialize
      initialize_validator
    end
  end

  #
  # ݒt@CǂݍރNXB
  # === CONFIGURATION FILE FORMAT
  #   # comment
  #   key1 = value1
  #   key2=value2
  #   ...
  #
  # === EXAMPLE 1
  #   file = File.open("abc.conf", "r")
  #   config = ConfigReader.read(file)
  #   p config["key1"]
  #
  class ConfigReader
    # t@CfBNg
    SEARCH_DIRS = [ "." ]

    attr_reader :search_path, :as_hash

    # w肳ꂽݒt@C̃tpX擾B
    # === ARGS
    # file_name:: ݒt@C̖O
    # === RETURNS
    # t@C̃tpX
    def self.resolve_path(file_name)
      resolved_path = nil
      SEARCH_DIRS.each do |dir|
        path = File.join(dir, file_name)
        if FileTest.exist?(path) \
          && !FileTest.directory?(path)
          resolved_path = path
          break
        end
      end
      return resolved_path
    end

    # FileIuWFNg܂̓t@CpX̕񂩂ݒt@Cǂݍ݁A
    # ̓ei[ĂIuWFNg(Hash܂OpenStruct)ԂB
    # === ARGS
    # input:: FileIuWFNg܂͐ݒt@CpX̕
    # as_hash:: ߂lHashŕԂǂ̃tOB
    #           HashŕԂꍇ+true+BOpenStructŕԂꍇ+false+B
    # === RETURNS
    # ݒt@C̓ei[ĂIuWFNg(Hash܂OpenStruct)
    def self.parse(input, as_hash = true)
      return ConfigReader.new(as_hash).parse(input)
    end

    # RXgN^
    # === ARGS
    # as_hash:: read\bh̖߂lHashŕԂǂ̃tOB
    #           HashŕԂꍇ+true+BOpenStructŕԂꍇ+false+B
    # validator:: ݒt@C؂of[^
    def initialize(as_hash = true, validator = nil)
      @as_hash = as_hash
      @validator = validator
      @validator ||= NullValidator.new
    end

    # FileIuWFNg܂̓t@CpX̕񂩂ݒt@Cǂݍ݁A
    # ̓ei[ĂIuWFNg(Hash܂OpenStruct)ԂB
    # === ARGS
    # input:: FileIuWFNg܂͐ݒt@CpX̕
    # === RETURNS
    # ݒt@C̓ei[ĂIuWFNg(Hash܂OpenStruct)
    def parse(input)
      case input
      when IO
        return read_from_io(input)
      when String
        return parse_by_path(input)
      else
        raise(ArgumentError, "arg1 must be an instance of File or String.")
      end
    end

    # IOݒǂݍ݁A̓ei[IuWFNg
    # (Hash܂OpenStruct)ԂB
    # === ARGS
    # io:: ݒi[ĂIOIuWFNg
    # === RETURNS
    # ݒt@C̓ei[ĂIuWFNg(Hash܂OpenStruct)
    # === RAISES
    # ConfigError:: ݒt@C̓esȏꍇ
    # IOError:: ݒt@C̓ǂݍ݂Ɏsꍇ
    def read_from_io(io)
      config = Hash.new

      errors = Array.new
      count = 0
      while line = io.gets
        count += 1
        # Rgsŝ݂̍s͖
        if /^#/ =~ line \
          || /^(\r\n|\n)$/ =~ line
          next
        end
        
        @validator.line = count
        
        array = line.split("=", 2)
        key = array[0].strip
        value = array[1].strip
        
        begin
          if @validator.respond_to?("validate_key_value")
            @validator.validate_key_value(key, value)
          end
        rescue ConfigFormatError => e
          errors << e
          next
        end

        config.store(key, value)
      end
      
      unless errors.empty?
        file_path = ""
        file_path = io.path if io.instance_of?(File)
        raise(ConfigError.new("Errors occurred while reading configuration.",
                              errors, file_path))
      end

      unless @as_hash
        require 'ostruct'
        return OpenStruct.new(config)
      end
      
      return config
    end

    # ̃t@CpXݒt@Cǂݍ݁A
    # ̓ei[ĂIuWFNg(Hash܂OpenStruct)ԂB
    # === ARGS
    # file:: ݒt@CłFileIuWFNg
    # === RETURNS
    # ݒt@C̓ei[ĂIuWFNg(Hash܂OpenStruct)
    # === RAISES
    # ConfigError:: ݒt@C̓esȏꍇ
    # IOError:: ݒt@C̓ǂݍ݂Ɏsꍇ
    # === SEE ALSO
    # resolve_path
    def read_by_path(path)
      begin
        file = File.open(path, "r")
        return read_from_io(file)
      ensure
        file.close if file != nil
      end
    end
  end #ConfigReader#
end
