#
# == dbc/dbc
#
#
require 'dbi/dbi'

module DBC

  class DBError < StandardError
  end

  class Transaction
    def begin
    end

  end

  #
  # f[^x[XƂ̐ڑZbVB
  #
  class Session
    def initialize(dbh, auto_commit)
      @dbh = dbh
      @auto_commit ||= auto_commit
    end

    def connected?
      return @dbh.connected?
    end

    def execute
    end

    def update
    end

    def transaction
      unless @auto_commit
      end
    end

    def close
      @dbh.disconnect
    end
  end

  #
  # ZbVǗNXBf[^x[XƂ̃RlNVǗB
  #
  class SessionManager
    
    # RXgN^B
    # === ARGS
    # driver:: ڑhCo
    # host:: ڑzXg
    # db_name:: ڑf[^x[X
    # user:: [U
    # password:: pX[h
    def initialize(driver, host, db_name, user, password)
      @driver = driver
      @host = host
      @db_name = db_name
      @user = user
      @password = password
      @sessions = []
    end

    # VSession𐶐B
    # === ARGS
    # auto_commit::R~bg[h\tOBtruȅꍇ͎R~bg[hONB
    # === RETURNS
    # Session
    def new_session(auto_commit = true)
      dbh = Session.new(DBI.connect("dbi:#{driver}:#{db_name}:#{host}",
                                            @user, @password))
      session = Session.new(dbh, auto_commit)
      @sessions << session
      return session
    end
    
    # ̃ZbV}l[WASĂSessionN[YB
    def close
      @sessions.each do |s|
        s.close
      end
    end
  end

end
