#
# == epcb/cli
# ExcelPettyCashBookR}hCc[pExitStatus`B
#
# Revision:: $Id$
#
require 'cli'
require 'log'
require 'epcb/errors'

module CLI
  class ExitStatus
    # CSVf[^̃tH[}bgs
    INVALID_CSV_DATA_FORMAT = 130
    # ExcelPettyCashBook̃o[Ws
    INVALID_WORKBOOK_VERSION = 140
  end
end #CLI#

module EPCB
  module CLI
    #
    # R}hC̃TuR}hɑNXB
    #
    class Subcommand
      attr_reader :command, :klass
      # RXgN^B
      # === ARGS
      # command:: TuR}h
      # klass:: ۂɏsNX
      def initialize(command, klass)
        @command = command
        @klass = klass
      end
    end #Subcommand#

    #
    # ExcelPettyCashBookR}hCc[ɓNX\bhNXB
    #
    class Helper
      def initialize(option_holder)
        @option_holder = option_holder
      end

      # ɂԂ\B
      # === ARGS
      # enabled:: Ԃ\邩ǂ̃tO
      # stopwatch:: StopwatchCX^X
      def report_elapsed_time(enabled, stopwatch)
        if enabled
          stopwatch.suspend
          puts "Elapsed #{format("%0.3f", stopwatch.time)} (sec)"
        end
      end

      # --verbose--debug̃IvVQƂA
      # K؂LoggerNX̃CX^X𐶐B
      # === ARGS
      # io:: Oo͐IOIuWFNg
      # === RETURNS
      # LoggerCX^X
      def create_logger(io)
        logger = nil
        if @option_holder.debug
          logger = Log::DebugLogger.new(io)
          logger.level = Logger::DEBUG
        else
          logger = Log::Logger.new(io)
          if @option_holder.verbose
            logger.level = Logger::INFO
          else
            logger.level = Logger::WARN
          end
        end
        return logger
      end

      # --benchIvV`B
      # === ARGS
      # opts:: IvV
      def define_bench(opts)
        opts.on("-b", "--bench",
                "report an elapsed time.") do |arg|
          @option_holder.bench = arg
        end
      end

      # --masterIvV`B
      # === ARGS
      # opts:: IvV
      def define_master(opts)
        opts.on("-m", "--master",
                "output master sheet data.") do |arg|
          @option_holder.master = arg
        end
      end

      # --outfileIvV`B
      # === ARGS
      # opts:: IvV
      def define_outfile(opts)
        opts.on("-o", "--outfile FILE", String,
                "specify a file name to be output.") do |arg|
          @option_holder.outfile = arg
        end
      end

      # --prefsIvV`B
      # === ARGS
      # opts:: IvV
      def define_prefs(opts)
        opts.on("-p", "--prefs",
                "output preferences.") do |arg|
          @option_holder.prefs = arg
        end
      end

      # --source-versionIvV`B
      # === ARGS
      # opts:: IvV
      def define_source_version(opts)
        opts.on("-S", "--source-version VERSION", String,
                "specify a source file version.") do |arg|
          @option_holder.source_version = arg
        end
      end

      # --templateIvV`B
      # === ARGS
      # opts:: IvV
      def define_template(opts)
        opts.on("-t", "--template FILE", String,
                "specify a template file.") do |arg|
          @option_holder.template = arg
        end
      end

      # --verboseIvV`B
      # === ARGS
      # opts:: IvV
      def define_verbose(opts)
        opts.on_tail("-V", "--verbose",
                     "enable verbose output.") do |arg|
          @option_holder.verbose = arg
        end
      end

      # --deubgIvV`B
      # === ARGS
      # opts:: IvV
      def define_debug(opts)
        opts.on_tail("-D", "--debug",
                     "enable debug output.") do |arg|
          @option_holder.debug = arg
        end
      end

      # --versionIvV`B
      # === ARGS
      # opts:: IvV
      # progname:: IvVw莞ɕ\vO
      # ver:: IvVw莞ɕ\o[W
      def define_version(opts, progname, ver)
        opts.on_tail("-v", "--version",
                     "print version information and exit.") do
          puts("#{progname} #{ver}")
          exit(0)
        end
      end

      # --helpIvV`B
      # === ARGS
      # opts:: IvV
      def define_help(opts)
        opts.on_tail("-h", "--help", "print this message and exit.") do
          puts(opts)
          exit(0)
        end
      end

      # Usage\CLI::ExitStatus::ARGUMENT_ERRORexit
      def print_usage_and_exit(status)
        ARGV.options { |opts| $stderr.puts(opts) }
        exit(status)
      end

      # TuR}hw肳Ă邩`FbNB
      # G[ɂȂꍇ͓K؂ȏIXe[^XexitB
      # G[ɂȂȂꍇ̓TuR}hɑΉ鏈sIuWFNgԂB
      # === ARGS
      # argv:: R}hC
      # subcommands:: TuR}h(Subcommand)̔z
      # === RETURNS
      # TuR}hɑΉ鏈sIuWFNg
      def check_subcommand_and_get_program(argv, subcommands)
        program = nil
        begin
          subcommands.each do |subc|
            if subc.command == argv[0]
              program = subc.klass.new
            end
          end
          # subcommandw肳ĂȂꍇ
          if program.nil?
            if argv[0] != nil
              Log::eoutln("Unknown subcommand \"#{argv[0]}\".\n")
            else
              Log::eoutln("Must specify a subcommand.\n")
            end
            print_usage_and_exit(::CLI::ExitStatus::ARGUMENT_ERROR)
          end
        end
        return program
      end

      # raiseꂽOK؂ɏ郁\bhB
      # === ARGS
      # e:: O
      # === RETURNS
      # exit̂߂̃G[R[h
      def handle_exception(e)
        status = ::CLI::ExitStatus::OK
        Log::eoutln(e.message) if !e.instance_of?(SystemExit)

        case e
        when ::CLI::CLIError
          status = e.code
        when IOError, Errno::EACCES
          ::CLI::print_backtrace(e)
          status = ::CLI::ExitStatus::IO_ERROR
        when Errno::ENOENT
          ::CLI::print_backtrace(e)
          status = ::CLI::ExitStatus::FILE_NOT_FOUND
        when EPCB::InvalidCSVDataFormatError
          status = ::CLI::ExitStatus::INVALID_CSV_DATA_FORMAT
        when EPCB::OptionUnsatisfiedError
          status = ::CLI::ExitStatus::OPTION_UNSATISFIED
        when EPCB::UnknownVersionError
          #::CLI::print_backtrace(e)
          status = ::CLI::ExitStatus::ARGUMENT_ERROR
        when EPCB::UnknownWorkbookVersionError
          status = ::CLI::ExitStatus::INVALID_WORKBOOK_VERSION
        when SystemExit
          exit($!.status)
        else
          $stderr.puts("Oops! Unexpected error. (#{e.message})")
          ::CLI::print_backtrace(e)
          status = ::CLI::ExitStatus::UNEXPECTED_ERROR
        end

        return status
      end
    end #Helper#

  end #CLI#

end #EPCB#
