#
# == epcb/common
# ExcelPettyCashBookR}hCc[̋ʋ@\AʃNX܂Ƃ߂t@CB
#
# Revision:: $Id$
#
require 'parsedate'
require 'log'
require 'win32ole-ext'
require 'epcb/cli'
require 'epcb/errors'
require 'epcb/feature'

module EPCB
  # CSVExcelPettyCashBook̃o[W
  TARGET_VERSION = "1.2"

  SUBC_CSV = "gencsv"
  SUBC_EXCEL = "genexcel"
  SUBC_ALL = "genall"

  SUBC_IMPORT = "import"
  SUBC_EXPORT = "export"

  # CSṼV[gɂvtBbNX
  CSV_SHEET_PREFIX = "$$"
  #   CSV_COL_SEP = ?,
  # CSV̍sZp[^
  CSV_LINE_SEP = "\r\n"

  # \r,\nGXP[v
  def EPCB.escape(str)
    return str if str.nil?
    s = str.gsub(/\r/, "\\r")
    s = str.gsub(/\n/, "\\n")
    return s
  end

  # }X^V[gǂ肷B
  def EPCB.master_sheet?(name)
    return (EPCB::MASTER_SHEET_NAME == name)
  end

  # vt@XV[gǂ肷B
  def EPCB.prefs_sheet?(name)
    return (EPCB::PREFS_SHEET_NAME == name)
  end

  # IvV--source-version܂ExcelPettyCashBook
  # ڍsExcelPettyCashBook̃o[W擾B
  def EPCB.get_source_version(eutil)
    ver = nil
    if $options.source_version.nil?
      # ExcelPettyCashBook̃}No[W擾
      ver = eutil.version_from_workbook
      if ver.nil?
        ver = "1.0.0"
      end
    else
      ver = $options.source_version
    end
    return ver
  end

  # versionɑΉCX^X𐶐B
  # === ARGS
  # class_name:: CX^X̃NX
  # version:: CX^X̃o[W(: "1.1.0")
  # eutil:: ExcelUtilNX̃CX^XB
  #         +version+ w肵Ăꍇ nil łOKB
  # args:: IuWFNg̃RXgN^ɓn
  def EPCB.new_specific_instance(class_name, eutil,
                                 version = nil, *args)
    if version.nil?
      version = get_source_version(eutil)
    end
    # minor2؂̂ĂāA".""_"ɒuĂCX^X
    ver = truncate_minor2(version)
    ver.gsub!(/\./, "_")
    #Log::debugln("new_specific_instance() #{class_name}_#{ver}")
    instance = nil
    begin
      instance = eval("#{class_name}_#{ver}").new(*args)
    rescue NameError => e
      v = version
      raise(UnknownVersionError, "Unknown version \"#{v}\"")
    end
    return instance
  end

  # IvVŎw肳ꂽo[WFeatureCX^X𐶐B
  # === ARGS
  # eutil:: ExcelUtilCX^X
  # ver:: Featurẽo[W
  # genexcel:: ExcelPettyCashBook𐶐鏈ĂяoĂ邩ǂ̃tO
  def EPCB.new_feature(eutil, ver = nil, genexcel = false)
    ver = get_source_version(eutil) if ver.nil?
    #Log::voutln("version = #{ver}")
    begin
      feature = new_specific_instance("Feature", eutil, ver, eutil)
    rescue UnknownVersionError => e
      # ExcelPettyCashBook𐶐鏈ĂяoĂꍇ́A
      # --templateŎw肳ꂽ[NubÑo[W
      # mł|̃G[raise
      if genexcel
        raise(UnknownWorkbookVersionError, e.message)
      else
        raise(e)
      end
    end
  end

  # x.y.z ̃o[W x.y ̕ԂB
  def EPCB.truncate_minor2(version)
    return nil if version.nil?
    if /^(\d+)\.(\d+)\.(\d+)$/ =~ version
      return "#{$1}.#{$2}"
    end
    return version
  end

  #
  # Excel֘Ã[eBeBNX
  #
  class ExcelUtil
    attr_reader :excel

    def initialize()
      @excel = nil
    end

    public
    def self.to_yyyymmdd_format(date_str, sep = "/")
      if date_str.nil? || date_str.empty?
        return nil
      end
      d = ParseDate.parsedate(date_str)
      return "#{d[0]}#{sep}#{d[1]}#{sep}#{d[2]}"
    end

    # ExcelCX^X𐶐
    # === RETURNS
    # ExcelCX^X
    def new_excel
      if @excel.nil?
        @excel = Excel.new(true, true)
      end
      return @excel
    end

    # ̃IuWFNgExcelCX^Xj
    def destroy_excel
      unless @excel.nil?
        @excel.quit
        @excel = nil
      end
    end

    # +path+Excelt@CJăANeBuɂB
    # === ARGS
    # path:: Excelt@C̃pX
    def open_workbook_and_activate(path, display_alerts = true)
      new_excel
      @excel.displayAlerts = display_alerts
      workbook = @excel.workbooks.open(path)
      workbook.activate
      return workbook
    end

    # +name+f[^V[gƂĐ肷B
    def is_valid_data_sheet_name(name)
      new_excel
      return @excel.run("IsValidDataSheetName", name)
    end

    # ANeBuȃV[g+Initialize+}NĂԁB
    def initialize_on_active_sheet()
      new_excel
      @excel.run("Initialize")
    end

    # ANeBuȃV[g+GetOffset+}NĂԁB
    def get_offset(line, column)
      new_excel
      return @excel.run("GetOffset", line, column)
    end

    # ExcelPettyCashBook̃o[W[NubN擾B
    def version_from_workbook
      begin
        new_excel
        return @excel.run("Const_VERSION")
      rescue WIN32OLERuntimeError => e
        return nil
      end
    end
  end #ExcelUtil#

end
