#
# == epcb/data
# ExcelPettyCashBookR}hCc[IɎgpf[^NXW߂t@CB
# 
# Revision:: $Id$
#
module EPCB
  # }X^V[g
  MASTER_SHEET_NAME = "}X^"
  # vt@XV[g
  PREFS_SHEET_NAME = "PREFS"

  #
  # Excel"/xof[^"1s̃Gg\f[^NXB
  #
  class IncomeExpensesData ; end

  #
  # 1.0pIncomeExpensesDataB
  #
  class IncomeExpensesData_1_0
    attr_accessor :date, :use, :amount_of_money, :note

    # RXgN^B
    # === ARGS
    # date:: t
    # use:: pr
    # amount_of_money:: z
    def initialize(date = nil, use = nil, amount_of_money = nil, note = nil)
      @date = date
      @use = use
      @amount_of_money = amount_of_money
      @note = note
    end

    # Excel̃JŃf[^i[zԂB
    def to_a
      return [ @date, @use, @amount_of_money, @note ]
    end

    def inspect
      return to_a.inspect
    end
  end #IncomeExpensesData_1_0#

  #
  # pr}X^\NXB
  #
  class UseMasterData
    attr_accessor :value, :note

    # RXgN^
    # === ARGS
    # value:: "H"Ȃǂ̒l
    # note:: l(2005/04/28ݎgpĂȂ)
    def initialize(value = nil, note = nil)
      @value = value
      @note = note
    end
  end

  #
  # 1.1pIncomeExpensesDataB`̂݁B
  #
  class IncomeExpensesData_1_1 < IncomeExpensesData_1_0 ; end

  #
  # 1.2pIncomeExpensesDataB`̂݁B
  #
  class IncomeExpensesData_1_2 < IncomeExpensesData_1_1 ; end

  #
  # Excel̃V[g\W[B
  #
  module NamedDataSet
    include Enumerable
    attr_reader :name
    @name = nil
    @data = Array.new

    # }X^f[^i[ĂNamedDataSetǂ肷B
    # ̎ł͏falseԂB
    # === RETURNS
    # }X^f[^i[Ăꍇtrue
    def master?
      return false
    end

    # vt@Xi[ĂNamedDataSetǂ肷B
    # ̎ł͏falseԂB
    # === RETURNS
    # vt@Xi[Ăꍇtrue
    def prefs?
      return false
    end

    # 1R[h̃f[^NamedDataSetɒǉB
    # === ARGS
    # data:: 1s̃f[^
    def add(data)
      @data << data
    end

    # ̃IuWFNgf[^s̐ԂB
    # === RETURNS
    # f[^s̐
    def size
      return @data.size
    end

    # ̃IuWFNgi[Ăf[^SĂǂB
    def each
      @data.each do |d|
        yield(d)
      end
    end
  end #NamedDataSet#

  #
  # ExcelPettyCashBook1̃f[^\NX(Excel̃f[^V[g1ɑ)B
  # IncomeExpensesDatai[B
  #
  class MonthData
    include NamedDataSet

    # RXgN^B
    # === ARGS
    # name:: V[g
    def initialize(name)
      @name = name
      @data = Array.new
    end
  end #MonthData#

  #
  # ExcelPettyCashBook̃}X^f[^NX(Excel̃}X^V[g\)B
  #
  class MasterData
    include NamedDataSet
    attr_accessor :use

    # RXgN^B
    def initialize
      @name = MASTER_SHEET_NAME
      @use = Array.new
    end
    
    # trueԂB
    def master?
      return true
    end

    # Ȃ
    def add(data) ; end

    # ̃}X^V[g}X^̐ԂB
    def size
      return to_a.size
    end

    # "pr}X^"̃f[^SĂǂB
    # ubN̈UseMasterData^łB
    def each_use
      @use.each do |d|
        yield(d)
      end
    end

    def to_a
      return [ @use ]
    end
  end #MasterData#

  class PreferencesData
    include NamedDataSet

    def initialize
      @name = PREFS_SHEET_NAME
      @data = Hash.new
    end

    def store(name, value)
      return if name.nil? || name == ""
      @data.store(name, value)
    end

    # trueԂB
    def prefs?
      return true
    end

    def add(data) ; end

    def each
      @data.each_pair do |name, value|
        yield(name, value)
      end
    end
  end #PreferencesData#
end


