#
# == epcb/excel-parser
#
# Revision:: $Id$
#
require 'epcb/data'
require 'epcb/common'

module EPCB
  #
  # ExcelPettyCashBook͂p[TB
  #
  class ExcelParser
    # RXgN^B
    # === ARGS
    # eutil:: ExcelUtil̃CX^X
    def initialize(eutil)
      @eutil = eutil
      @feature = nil
    end

    # ExcelV[g͂A͌ʂłMonthDatãCX^XԂB
    # === ARGS
    # sheet:: ͂V[g
    # === RETURNS
    # ͌ʂłMonthDatãCX^X
    def parse(sheet)
      @feature = EPCB::new_feature(@eutil) if @feature.nil?
      data_set = nil
      is_master = false # "}X^"V[gǂ\tO
      # f[^V[g̏ꍇ
      if @eutil.is_valid_data_sheet_name(sheet.name)
        data_set = MonthData.new(sheet.name)
      # --masterw肳Ăă}X^V[g̏ꍇ
      elsif $options.master && EPCB::master_sheet?(sheet.name)
        data_set = MasterData.new
        is_master = true
      elsif $options.prefs && EPCB::prefs_sheet?(sheet.name)
        data_set = PreferencesData.new
        prefs_names = @feature.get_preferences_names()
        Log::debugln("prefs_names = #{prefs_names.inspect}")
        prefs_names.each do |name|
          value = @feature.get_preference(name)
          Log::debugln("prefs = { #{name} = #{value} }")
          data_set.store(name, value)
        end
        return data_set
      # ̑AǂłV[g̏ꍇ
      else
        return nil
      end
      
      Log::voutln("Parsing sheet \"#{sheet.name}\"")
      sheet.activate
      @eutil.initialize_on_active_sheet
      # f[^sSĒׂ
      for i in 0 .. @feature.const_of("MAX_DATA_LINE")
        # }X^V[g̏ꍇ
        if is_master
          # cellsCells(s, )
          value = sheet.cells(i + 1, 1).value
          # 3sȏ󂾂珈𔲂
          if value.nil?
            empty = true
            for j in 2 .. 3
              unless sheet.cells(i + j, 1).value.nil?
                empty = false
                break
              end
            end
            break if empty
            value = ""
          end
          data_set.use << UseMasterData.new(value)
        # ʏ̃f[^V[g̏ꍇ
        else
          break if @feature.is_empty_line_continued_to_limit(i)
          # 1s̃f[^TuNX̃\bhŎ擾B
          income_expenses_data = get_income_expenses_data(i)
          #puts "#{i} = #{income_expenses_data}"
          # data_setɑ΂1s̃f[^ǉ
          data_set.add(income_expenses_data)
        end
      end

      Log::voutln("Finished to parse sheet \"#{sheet.name}\"\n")
      return data_set
    end

    # Excelf[^V[g1s̃f[^擾BTuNXŃI[oChB
    # === ARGS
    # line:: 擾f[^̍sItZbg
    # === RETURNS
    # Excelf[^V[g1s̃f[^i[z
    def get_income_expenses_data(line) ; end
  end #ExcelParser#

  #
  # o[W1.0pExcelParser
  #
  class ExcelParser_1_0 < ExcelParser
    # "t"A"pr"A"z"߂l̃f[^Ɋi[B
    # "l"ɂ +nil+ ݒ肳B
    def get_income_expenses_data(line)
      # t
      date = @eutil.get_offset(line, @feature.const_of("DATE_OFFSET")).value
      # YYYY/MM/DDɕϊ
      date = ExcelUtil.to_yyyymmdd_format(date)

      # pr
      use = @eutil.get_offset(line, @feature.const_of("USE_OFFSET")).value

      # z
      amount = @eutil.get_offset(line,
                                 @feature.const_of("AMOUNT_OF_MONEY_OFFSET")).value
      amount = amount.truncate if amount != nil
      return EPCB::new_specific_instance("IncomeExpensesData", @eutil, nil,
                                         date, use, amount)
    end
  end #ExcelParser_1_0#

  #
  # o[W1.1pExcelParser
  #
  class ExcelParser_1_1 < ExcelParser_1_0
    # 1.0̃f[^ɉāAł"l"i[߂l̃f[^Ɋi[B
    def get_income_expenses_data(line)
      data = super(line)
      data.note = @eutil.get_offset(line,
                                    @feature.const_of("NOTE_OFFSET")).value
      return data
    end
  end #ExcelParser_1_1#

  #
  # o[W1.2pExcelParserB`̂݁B
  #
  class ExcelParser_1_2 < ExcelParser_1_1 ; end

end
