#
# == epcb/csv/feature
#
# Revision:: $Id$
#
module EPCB
  #
  # ExcelPettyCashBook̃o[WɂāApł}NȂǂقȂ̂
  # ̈Ⴂ𖄂߂邽߂̃NXBo[WɓL̋@\ǉꍇ
  # TuNX쐬ĎB
  #
  class Feature
    # RXgN^B
    # === ARGS
    # excel_util:: ExcelUtil̃CX^X
    def initialize(excel_util)
      @util = excel_util
      @constants_cache = Hash.new
    end

    # ExcelPettyCashBookŒ`Ă萔擾B
    # === ARGS
    # name:: 萔
    def const_of(name)
      value = @constants_cache[name]
      if value.nil?
        value = @util.excel.run("Const_#{name}")
        @constants_cache[name] = value
      end
      return value
    end

    # f[^s萔󔒍sł邩肷B
    # IsEmptyLineContinuedToLimit}NĂԂƂŔ肷B
    # === ARGS
    # line:: 肷s̃ItZbg
    def is_empty_line_continued_to_limit(line)
      if @util.excel.run("IsEmptyLineContinuedToLimit", line) &&
          @util.get_offset(line, const_of("DATE_OFFSET")).value.nil?
        return true
      end
    end

    # workbookAOname[NV[g擾B
    # === ARGS
    # workbook:: [NubN
    # name:: 擾V[g̖O
    # === RETURNS
    # [NV[gBȂꍇnilB
    def get_sheet(workbook, name)
      for i in 1 .. workbook.worksheets.count
        s = workbook.worksheets(i) 
        return s if s.name == name
      end
      return nil
    end

    def get_master_sheet(workbook)
      return get_sheet(workbook, EPCB::MASTER_SHEET_NAME)
    end
    
    def get_prefs_sheet(workbook)
      return get_sheet(workbook, EPCB::PREFS_SHEET_NAME)
    end

    # vt@X[hB̎ł͏falseԂB
    # === RETURNS
    # vt@X̃[hɐꍇtrue
    def load_preferences()
      # Ȃ
      return false
    end

    # vt@XɊi[Ă閼OzƂđSĎ擾B
    # ̎ł͏nilԂB
    # === RETURNS
    # vt@XɊi[Ă閼O
    def get_preferences_names()
      #return @util.excel.run("GetPreferencesNames")
      return nil
    end

    # ̃vt@XɑΉvt@Xl擾B
    # ̎ł͏nilԂB
    # === RETURNS
    # vt@XlB
    def get_preference(name)
      return nil
    end

    # namevaluevt@XɊi[B
    # ̎ł͉Ȃ
    # === ARGS
    # name:: vt@X
    # value:: vt@Xl
    def put_preference(name, value) ; end

    # ANVtH[̈ʒuXVB
    # ̎ł͉Ȃ
    def upadte_action_form_location() ; end

    # ̃V[g+name+}X^V[g̐Oǂ肷B
#     def master_sheet?(name)
#       # $options.master̔͂Ȃ͂
#       return const_of("MASTER_SHEET_NAME") == name
#     end
  end #Feature#

  #
  # 1.0FeatureB
  #
  class Feature_1_0 < Feature
    def const_of(name)
      value = @constants_cache[name]
      return value unless value.nil?

      case name
      when "VERSION"
        value = "1.0.0"
      when "DEFAULT_BASE_LOCATION"
        value = "A7"
      when "MAX_DATA_LINE"
        value = 400
      when "TEMPLATE_SHEET_NAME"
        value = "^"
      when "MASTER_SHEET_NAME"
        value = "}X^"
      when "DATE_OFFSET"
        value = 0
      when "DAY_OF_WEEK_OFFSET"
        value = 1
      when "USE_OFFSET"
        value = 2
      when "AMOUNT_OF_MONEY_OFFSET"
        value = 3
      else
        return nil
      end
      @constants_cache[name] = value
      return value
    end

  end #Feature_1_0#

  #
  # 1.1FeatureB`̂݁B
  #
  class Feature_1_1 < Feature ; end 

  #
  # 1.2FeatureB
  #    #
  class Feature_1_2 < Feature_1_1
    def get_sheet(workbook, name)
      @util.excel.run("GetSheet", workbook, name, false)
    end

    def load_preferences()
      return @util.excel.run("LoadPreferences")
    end

    def get_preferences_names()
      return @util.excel.run("GetPreferencesNames")
    end

    def get_preference(name)
      return @util.excel.run("GetPreference", name)
    end

    def put_preference(name, value)
      @util.excel.run("PutPreference", name, value)
    end

    def update_action_form_location
      @util.excel.run("UpdateActionFormLocation")
    end
  end 

end
