#
# == epcb/test/cli/common
# C^tF[XeXg̋ʃt@CB
#
# Revision:: $Id$
#
require 'epcb/test/common'

#
# R}hC^tF[XeXgp̖O
#
module EPCB::Test::CLI
  #
  # C^tF[XeXg̃R}hCwp[NXB
  #
  class Helper < ::EPCB::CLI::Helper
    def initialize(option_holder)
      super(option_holder)
    end

    def register_at_exit(ios)
      at_exit do
        ios.each do |io|
          begin
            io.close
          rescue IOError
            # Ignore
          ensure
            begin
              if File.exists?(io.path) && $options.remove_std
                FileUtils.rm(io.path)
              end
            rescue
              # Ignore
            end
          end
        end
      end
    end

    # --data-dirIvV`B
    # === ARGS
    # opts:: IvV
    def define_data_dir(opts)
      # --datadir
      opts.on("-d", "--data-dir DIR", String,
              "specify test data directory. " \
              "(default: \"#{$options.data_dir}\")") do |arg|
        $options.data_dir = arg
      end
    end

    # --programIvV`B
    # === ARGS
    # opts:: IvV
    def define_program(opts)
      opts.on("-p", "--program FILE", String,
              "sepcify a program of epcb-csv to run. " \
              "(default: \"#{$options.program}\")") do |arg|
        $options.program = arg
      end
    end

    # --removeIvV`B
    # === ARGS
    # opts:: IvV
    def define_remove(opts)
      opts.on("-r", "--remove",
              "remove temporarily redirected \"stdout\" and \"stderr\".") do |arg|
        $options.remove_std = arg
      end
    end

    # --tmp-dirIvV`B
    # === ARGS
    # opts:: IvV
    def define_tmp_dir(opts)
      opts.on("-t", "--tmp-dir DIR",
              "specify temporary directory. " \
              "(default: \"#{$options.tmp_dir}\"") do |arg|
        $options.tmp_dir = arg
      end
    end
  end #Helper#

  #
  # TestCasepwp[NXB
  #
  class EPCB::Test::CLI::TestCaseHelper
    require 'test/unit/assertions'
    include ::Test::Unit::Assertions

    attr_reader :putil, :eutil

    # RXgN^
    # === ARGS
    # out:: Wo͂̃_CNg
    # err:: WG[o͂̃_CNg
    # remove_std:: _CNgWo͂̃t@C폜邩ǂ̃tO
    def initialize(out, err, remove_std = false)
      @putil = EPCB::Test::ProcessUtil.new(remove_std)
      @putil.set_redirection(out, "stdout")
      @putil.set_redirection(err, "stderr")
      @eutil = EPCB::ExcelUtil.new
    end
    
    def destroy
      @eutil.destroy_excel
    end
    
    # TuR}h+genall+sAꂽExcelPettyCashBook̃f[^؂B
    # === ARGS
    # name:: t@C(gq͊܂߂Ȃ)
    # template:: ڍso[W̃ev[gt@C
    # outfile:: o͐t@CpX
    # data_array:: ؂Ŏgpf[^̔z
    # validate_proc:: ؂ۂɎsubN
    def genall_and_validate_excel(name, template, outfile,
                                  data_array, &validate_proc)
      run_command("genall", name, "-t #{$options.data_dir}/#{template} -o #{outfile}")
      assert(FileTest.exist?(outfile))

      dest_path = File.file_system.getAbsolutePathName(outfile)
      sheet_names = get_sheet_names(data_array)
      begin
        workbook = @eutil.open_workbook_and_activate(dest_path)
        start_index = 1
        for i in (6 .. workbook.worksheets.count) # 6: f[^V[g̎n܂
          sheet = workbook.worksheets(i)
          assert_equal(sheet_names[i-6], sheet.name)
          sheet.activate
          @eutil.initialize_on_active_sheet

          # data_arrayeV[gƂ̃f[^2z쐬
          sheet_data = Array.new
          for j in (start_index .. data_array.size - 1)
            if data_array[j].size == 1
              start_index = j + 1
              break
            end
            sheet_data << data_array[j].dup
          end
          puts "sheet_data = #{sheet_data.inspect}"

          # ݂Ȃ͂̃f[^sV[gɂȂmF
          7.times { |j| assert_nil(@eutil.get_offset(sheet_data.size, j).value) }

          # eV[gƂ̃f[^gpāÃubNs
          sheet_data.size.times do |line|
            7.times do |column|
              validate_proc.call(sheet_data, line, column)
            end
          end
        end
      ensure
        @eutil.destroy_excel
      end
    end #genall_and_validate_excel#

    # V[gi[z擾B
    # === ARGS
    # array:: ؂Ŏgpf[^z
    # === RETURNS
    # V[gi[z
    def get_sheet_names(array)
      sheet_names = Array.new
      array.size.times do |i|
        if array[i].size == 1
          name = array[i][0]
          # 擪$$폜Ă
          sheet_names << name.sub(/^\$\$/, "")
        end
      end
      return sheet_names
    end

    # TuR}h+gencsv+sAꂽCSVt@C؂B
    # === ARGS
    # name:: CSVt@C(gq͊܂߂Ȃ)
    # data:: ؗpf[^z
    # opt:: R}hɓnIvV
    def gencsv_and_validate_csv(name, data, opt = nil)
      out_file = "#{$options.tmp_dir}/#{name}.csv"
      opt = "" if opt.nil?
      opt += "#{opt} -o #{out_file}"
      run_command("gencsv", name, opt)
      validate_csv(out_file, data)
    end

    # +subcommand+sAexit_status 0 ł邱ƂmFB
    # === ARGS
    # subcommand:: TuR}h(gencsv, genall̂ꂩ)
    # name:: ڍsExcelPettyCashBook
    # opt:: R}hɓnIvV
    def run_command(subcommand, name, opt = nil)
      cmd = "#{$options.program} #{subcommand} #{$options.data_dir}/#{name}.xls"
      cmd += " #{opt}" unless opt.nil?
      @putil.quiet_run(cmd)
      assert_equal(0, @putil.exit_status)
    end

    # CSVt@C؂
    # === ARGS
    # file_path:: CSVt@CpX
    # data:: CSVt@C̃f[^Ɣr邽߂̌؃f[^z
    def validate_csv(file_path, data)
      assert(File.exist?(file_path))
      File.open(file_path, "rb") do |file|
        i = 0
        file.each do |line|
          row = CSV.parse_line(line, ?,, EPCB::CSV_LINE_SEP)
          assert_equal(data[i].size, row.size,
                       "L#{i+1}: CSṼJs")
          data[i].size.times do |j|
            assert_equal(data[i][j], row[j].to_s,
                         "L#{i+1} C#{j+1}: J̃f[^s")
          end
          i = i + 1
        end
      end
    end
  end #TestCaseHelper#

end
