#
# == epcb/test/common
# P̃eXg/C^tF[XeXg̋ʃt@CB
#
# Revision:: $Id$
#

module EPCB
  #
  # eXgpOԁB
  #
  module Test
    # 
    # R}hs邽߂̃[eBeBB
    #
    class ProcessUtil

      def initialize(rm_redirected_files = false)
        @redirect_map = Hash.new
      end

      # ̃IuWFNggpăR}hsۂɁA
      # WóAWG[o͂_CNg悤ɐݒ肷B
      # === ARGS
      # redirect_io:: _CNgIOIuWFNg
      # type:: _CNgo͂̎ʁB
      #        (stdout: Wo, stderr:: WG[o)
      def set_redirection(redirect_io, type)
        @redirect_map[type] = redirect_io
      end

      # WóAWG[o͂_CNg悤ɐݒ肵ԂŁA
      # ̃R}hsB
      # === ARGS
      # command:: sR}h
      def quiet_run(command, file = nil, line = nil)
        stdout = @redirect_map["stdout"]
        stderr = @redirect_map["stderr"]
        if stdout.nil? || stderr.nil?
          raise(StandardError, "You must set redirection by \"set_redirection\".")
        end
        redirect_run(command, stdout, stderr, file, line)
      end

      def redirect_run(command, out, err, file = nil, line = nil)
        stdout_save = STDOUT.dup
        stderr_save = STDERR.dup
        list = [ STDOUT, STDERR ]
        begin
          STDOUT.reopen(out)
          STDERR.reopen(err)
          if /^(.+?):(\d+)(?::in `(.*)')?/ =~ caller[2]
            file = $1 if file.nil?
            line = $2.to_i if line.nil?
          end
          list.each do |io|
            f = ""
            f = File.basename(file) if file != nil
            io.puts "FILE:#{f} LINE:#{line}"
            io.puts "$ #{command}"
          end
          system(command)
        ensure
          begin
            list.each do |io|
              io.puts ""
              io.flush
            end
          rescue
            # Ignore
          end
          STDOUT.reopen(stdout_save)
          STDERR.reopen(stderr_save)
        end
      end

      # ̃IuWFNgŌɎsR}hexitXe[^X擾B
      # === RETURNS
      # ŌɎsR}hexitXe[^X
      def exit_status
        return $? >> 8
      end
    end #ProcessUtil#

    #
    # R}hC^tF[XeXgp̖O
    #
    module CLI
      class Helper < ::EPCB::CLI::Helper
        def initialize(option_holder)
          super(option_holder)
        end

        def register_at_exit(ios)
          at_exit do
            ios.each do |io|
              begin
                io.close
              rescue IOError
                # Ignore
              ensure
                begin
                  if File.exists?(io.path) && $options.remove_std
                    FileUtils.rm(io.path)
                  end
                rescue
                  # Ignore
                end
              end
            end
          end
        end

        # --data-dirIvV`B
        # === ARGS
        # opts:: IvV
        def define_data_dir(opts)
          # --datadir
          opts.on("-d", "--data-dir DIR", String,
                  "specify test data directory. " \
                  "(default: \"#{$options.data_dir}\")") do |arg|
            $options.data_dir = arg
          end
        end

        # --programIvV`B
        # === ARGS
        # opts:: IvV
        def define_program(opts)
          opts.on("-p", "--program FILE", String,
                  "sepcify a program of epcb-csv to run. " \
                  "(default: \"#{$options.program}\")") do |arg|
            $options.program = arg
          end
        end

        # --removeIvV`B
        # === ARGS
        # opts:: IvV
        def define_remove(opts)
          opts.on("-r", "--remove",
                  "remove temporarily redirected \"stdout\" and \"stderr\".") do |arg|
            $options.remove_std = arg
          end
        end

        # --tmp-dirIvV`B
        # === ARGS
        # opts:: IvV
        def define_tmp_dir(opts)
          opts.on("-t", "--tmp-dir DIR",
                  "specify temporary directory. " \
                  "(default: \"#{$options.tmp_dir}\"") do |arg|
            $options.tmp_dir = arg
          end
        end
      end #Helper#

    end #CLI#

  end #Test#

end #EPCB#
