#
# == log
# JX^OóB
#
# Revision:: $Id$
#
require 'logger'

module Log
  #
  # JX^Oo̓NXBL̃tH[}bgŃOo͂B
  #   INFO : <bZ[W>
  #
  class Logger < Logger
    FORMAT = "%-5s: %s\n"

    def add(severity, message = nil, progname = nil, &block)
      severity ||= UNKNOWN
      if @logdev.nil? or severity < @level
        return true
      end
      progname ||= @progname
      if message.nil?
        if block_given?
          message = yield
        else
          message = progname
          progname = @progname
        end
      end
      @logdev.write(FORMAT % [ format_severity(severity), msg2str(message) ])
      true
    end
  end

  #
  # JX^fobOOo̓NXBL̃tH[}bgŃOo͂B
  #   DEBUG: hh:mm:ss.MMM <bZ[W>
  #
  class DebugLogger < Logger
    FORMAT = "%s %-5s: %s\n"

    def add(severity, message = nil, progname = nil, &block)
      severity ||= UNKNOWN
      if @logdev.nil? or severity < @level
        return true
      end
      progname ||= @progname
      if message.nil?
        if block_given?
          message = yield
        else
          message = progname
          progname = @progname
        end
      end
      now = Time.new
      tformat = "%H:%M:%S."
      tformat ||= @datetime_format
      now_str = now.strftime(tformat) << "%03d" % (now.usec / 1000)
      @logdev.write(FORMAT % [now_str, format_severity(severity), msg2str(message)])
      true
    end
  end

  def eoutln(message = "")
    if defined?($errlog)
      $errlog.error(message)
    else
      $stderr.puts(Logger::FORMAT % [ "ERROR", message ])
    end
  end

  def voutln(message = "")
    if defined?($log)
      $log.info(message)
    end
  end

  def woutln(message = "")
    if defined?($errlog)
      $errlog.warn(message)
    else
      $stderr.puts(Logger::Format % [ "WARN", message ])
    end
  end

  def debugln(message = "")
    if defined?($log)
      $log.debug(message)
    end
  end

  module_function :eoutln, :voutln, :woutln, :debugln
end
