#
# == win32ole-ext
# win32oleg₷邽߂̋@\񋟂B
#
# Revision:: $Id$
#
require 'win32ole'

# File
class File
  @file_system = nil

  # win32FileSystemObject擾B
  def self.file_system
    if @file_system.nil? then
      @file_system = WIN32OLE.new('Scripting.FileSystemObject')
    end
    return @file_system
  end
end #File#

class WIN32OLE
  @const_defined = Hash.new
  # win32ole̒萔[hĂWIN32OLECX^X𐶐B
  def self.new_with_const(prog_id, const_name_space)
    result = WIN32OLE.new(prog_id)
    unless @const_defined[const_name_space]
      WIN32OLE.const_load(result, const_name_space)
      @const_defined[const_name_space] = true
    end
    return result
  end
end #WIN32OLE#

module Excel

  # win32oleExcel.ApplicationCX^X𐶐B
  # === ARGS
  # visible:: Excel邩ǂ̃tO
  # display_alerts:: displayAlertstOBfalsȅꍇ͌xbZ[W\ȂB
  def self.new(visible = true, display_alerts = false)
    excel = WIN32OLE.new_with_const('Excel.Application', Excel)
    excel.visible = visible
    excel.displayAlerts = display_alerts
    return excel
  end

  # ExcelJĂԂɈ̃ubNsB
  # === ARGS
  # visible:: Excel邩ǂ̃tO
  # display_alerts:: displayAlertstOBfalsȅꍇ͌xbZ[W\ȂB
  # block:: subN
  def self.run_during(visible = true, display_alerts = false, &block)
    begin
      excel = new(visible, display_alerts)
      block.call(excel)
    ensure
      excel.quit
    end
  end
end #Excel#
