#!/usr/bin/ruby -w

#
# == epcb-csv.rb
# epcb-csv.exẽtgGhB
#
# Revision:: $Id$ 
#
require 'optparse'
require 'stopwatch'
require 'log'
require 'epcb/cli'
require 'epcb/csv/all-generator'

$KCODE = "s"

MY_NAME = "epcb-csv"
MY_VERSION = "1.2.0"

# Usage\CLI::ExitStatus::ARGUMENT_ERRORexit
def print_usage_and_exit()
  ARGV.options { |opts| $stderr.puts(opts) }
  exit(CLI::ExitStatus::ARGUMENT_ERROR)
end


stopwatch = Stopwatch.new
stopwatch.start
#GC.start

#require 'epcb/cli-vars.rb'
require 'ostruct'

$options = OpenStruct.new
$options.bench = false
$options.debug = false
$options.verbose = false
$options.source_version = nil
$options.outfile = nil
$options.template = nil
$options.leave = false
$options.master = false
$options.prefs = false

helper = EPCB::CLI::Helper.new($options)
subcommands = [
  EPCB::CLI::Subcommand.new(EPCB::SUBC_CSV, EPCB::CSV::CSVGenerator),
  EPCB::CLI::Subcommand.new(EPCB::SUBC_EXCEL, EPCB::CSV::ExcelGenerator),
  EPCB::CLI::Subcommand.new(EPCB::SUBC_ALL, EPCB::CSV::CSVAndExcelGenerator),
]

ARGV.options do |opts|
  opts.banner = <<BANNER
Usage: #{MY_NAME}.exe subcommand [options] SOURCE_FILE

#{MY_NAME}.exe (ver #{MY_VERSION}) is a CSV data file generator and ExcelPettyCashBook generator from a CSV. #{MY_NAME} needs a subcommand and available subcommands are following.
    - '#{EPCB::SUBC_CSV}'   generates a CSV data file
    - '#{EPCB::SUBC_EXCEL}' generates ExcelPettyCashBook (an Excel file)
    - '#{EPCB::SUBC_ALL}'   means both 'gencsv' and 'genexcel' are specified
BANNER

  opts.separator("")
  opts.separator("subcommand '#{EPCB::SUBC_CSV}' specific options are:")
  # --source-version
  helper.define_source_version(opts)

  opts.separator("subcommand '#{EPCB::SUBC_EXCEL}' specific options are:")
  # --template
  helper.define_template(opts)

  opts.separator("subcommand '#{EPCB::SUBC_ALL}' specific options are:")
  # --leave
  opts.on("-l", "--leave",
          "leave a CSV data file.") do |arg|
    $options.leave = arg
  end

  opts.separator("options are:")
  # --outfile
  helper.define_outfile(opts)
  # --master
  helper.define_master(opts)
  # --prefs
  helper.define_prefs(opts)
  # --bench
  helper.define_bench(opts)
  # --debug
  helper.define_debug(opts)
  # --verbose
  helper.define_verbose(opts)
  # --version
  helper.define_version(opts, MY_NAME, MY_VERSION)
  # --help
  helper.define_help(opts)

  #
  # IvV̉
  #
  opts.parse!
end or exit(CLI::ExitStatus::ARGUMENT_ERROR)

#
# OIuWFNg
#
$log = helper.create_logger($stdout)
$errlog = Log::Logger.new($stderr)
$errlog.level = Logger::WARN

program = nil
exit_status = CLI::ExitStatus::OK
begin
  program = helper.check_subcommand_and_get_program(ARGV, subcommands)

  if ARGV[1].nil?
    Log::eoutln("Must specify SOURCE_FILE.")
    exit(CLI::ExitStatus::ARGUMENT_ERROR)
  end

  program.setup(ARGV[1], $options.outfile)
  program.execute
  Log::voutln("The process successfully finished.")
rescue Exception => e
  exit_status = helper.handle_exception(e)
ensure
  program.destroy unless program.nil?
  $errlog.close
  $log.close
end

if exit_status != CLI::ExitStatus::OK
  exit(exit_status)
end

# vԂ\
helper.report_elapsed_time($options.bench, stopwatch)
