#
# == epcb/csv/all-generator
# ÂExcelPettyCashBookVExcelPettyCashBooko͂@\񋟂B
#
# Revision:: $Id$
#
require 'fileutils'
require 'epcb/excel-parser'
require 'epcb/excel-serializer'
require 'epcb/csv/common'
require 'epcb/csv/csv-serializer'
require 'epcb/csv/csv-parser'

module EPCB::CSV
  #
  # ExcelPettyCashBookCSVt@C𐶐GeneratorB
  #
  class CSVGenerator < Generator
    # ǂݍރt@CƏo͂t@C肷B
    # +dest_file+ nil ̏ꍇ+src_file+o͐̃pX肷B
    # === ARGS
    # src_file:: ǂݍExcelPettyCashBookt@C
    # dest_file:: o͂CSVt@C
    def setup(src_file, dest_file = nil)
      super(src_file, dest_file)

      if dest_file.nil?
        # \[Xt@Co͐t@C߂
        name = File.basename(src_file, ".*")
        @dest_path = File.file_system.getAbsolutePathName("#{name}.csv")
        Log::voutln("dest_path = #{@dest_path}")
      end
    end

    # ExcelPettyCashBook̃f[^zグāACSVt@Cɏo͂B
    def execute
      workbook = @eutil.open_workbook_and_activate(@src_path)
      @parser = EPCB::new_specific_instance("ExcelParser",
                                            @eutil, nil, @eutil)
      File.open(@dest_path, "wb") do |dest_file|
        @serializer = CSVSerializer.new(dest_file)
        # Excel̃V[gSׂ
        for i in 1 .. workbook.worksheets.count
          sheet = workbook.worksheets(i)
          data_set = @parser.parse(sheet)
          @serializer.serialize(data_set) unless data_set.nil?
        end
      end
    end
  end #CSVGenerator#

  #
  # CSVf[^zグExcelPettyCashBooko͂GeneratorB
  #
  class ExcelGenerator < Generator
    def initialize
      super()
      @template_path = nil
    end

    # ǂݍރt@CƏo͂t@C肷B
    # dest_filenil̏ꍇsrc_fileo͐̃pX肷B
    # ܂AIvV--templatew肳Ă邩`FbNB
    #
    # === ARGS
    # src_file:: ǂݍExcelPettyCashBookt@C
    # dest_file:: o͂CSVt@C
    def setup(src_file, dest_file = nil)
      super(src_file, dest_file)
      if $options.template.nil?
        raise(EPCB::OptionUnsatisfiedError,
              "specify --template option" \
              " for subcommand \"#{EPCB::SUBC_EXCEL}\" or \"#{EPCB::SUBC_ALL}\".")
      end
      ::CLI::ensure_file_exist($options.template)
      @template_path = File.file_system.getAbsolutePathName($options.template)

      if dest_file.nil?
        # \[Xt@Co͐t@C߂
        # pXK: <JgfBNg>/_<l>_<\[Xt@C>.xls
        prefix = "#{Dir::pwd}/_"
        for i in 1 .. 50000
          path = "#{prefix}#{i.to_s}_#{File.basename(@src_path, ".*")}.xls"
          Log::voutln("Created path = #{path}")
          break unless FileTest.exist?(path)
        end
        @dest_path = File.file_system.getAbsolutePathName(path)
        Log::voutln("dest_path = #{@dest_path}")
      end
      Log::voutln("template_path = #{@template_path}")
      FileUtils.cp(@template_path, @dest_path, :verbose => $options.verbose)
    end
    
    # CSVt@C̃f[^zグāAExcelPettyCashBookɏo͂B
    def execute
      super()
      Log::voutln

      workbook = @eutil.open_workbook_and_activate(@dest_path)
      @serializer = ::EPCB::ExcelSerializer.new(workbook, @eutil)
      @parser = CSVParser.new(@src_path)
      while @parser.has_next_line?
        data_set = @parser.parse
        Log::voutln("Finished to parse sheet \"#{data_set.name}\".\n")
        @serializer.serialize(data_set)
      end

      # Sf[^V[g̃f[^vZ
      @eutil.excel.run("CalculateAllForEverySheet")
      workbook.save
    end
  end #ExcelGenerator#

  #
  # ÂExcelPettyCashBookCSVf[^𐶐āA
  # VExcelPettyCashBookɃf[^ڍsNXB
  #
  class CSVAndExcelGenerator < Generator
    def initialize
      super()
      @csv_generator = CSVGenerator.new
      @excel_generator = ExcelGenerator.new
    end

    def setup(src_file, dest_file = nil)
      @csv_generator.setup(src_file, nil)
      csv_path = @csv_generator.dest_path
      # csv_path̃t@CȂꍇAExcelGenerator#setupŃG[ɂȂ̂ŁA
      # ̃t@C쐬Ă
      FileUtils.touch(csv_path, :verbose => $options.verbose)
      @excel_generator.setup(csv_path, dest_file)
    end

    def execute
      begin
        @csv_generator.execute
      ensure
        @csv_generator.destroy
      end
      @excel_generator.execute
    end

    def destroy
      super()
      begin
        @csv_generator.destroy
        @excel_generator.destroy
      ensure
        if @csv_generator.dest_path != nil \
          && FileTest.exist?(@csv_generator.dest_path) \
          && !$options.leave
          # CSVt@C폜
          FileUtils.rm(@csv_generator.dest_path,
                       :force => true, :verbose => $options.verbose)
        end
      end
    end
  end #CSVAndExcelGenerator#
end
