# == epcb/csv/csv-parser
#
# Revision:: $Id$
#
require 'csv'
require 'epcb/csv/common'

#
# AbvO[hf[^i[CSV͂p[TB
#
class EPCB::CSV::CSVParser
  # RXgN^B
  # === ARGS
  # src_path:: ͂CSVt@C̃pX
  def initialize(src_path)
    @src_file = File.open(src_path, "r")
    #@src_file.binmode
    @line_offset = 0
  end

  # ͂t@Cɂ܂ǂݍłȂs݂邩ǂ肷B
  # === RETURNS
  # ͂t@Cɂ܂ǂݍłȂs݂ꍇ true
  def has_next_line?
    return !@src_file.closed? && !@src_file.eof?
  end

  # RXgN^œnꂽFile͂A1V[g
  # MonthDataCX^XԂB
  #
  # === RETURNS
  # ͌ʂł1V[gMonthData
  def parse
    return parse_with_offset(@line_offset)
  end

  # RXgN^œnꂽFile +line_offset+ ̈ʒu͂A
  # 1V[gMonthDataCX^XԂB
  # === ARGS
  # line_offset:: ͂Jns̈ʒu
  # === RETURNS
  # ͌ʂł1V[gMonthData
  def parse_with_offset(offset)
    data_set = nil
    #puts "parse_with_offset: offset = #{offset}"
    while true
      tmp = @src_file.gets
      if tmp.nil?
        #puts "CALL destory()"
        # ͂f[^͂Ȃ̂ŁAdestroyĂ
        destroy
        break
      end

      #puts "tmp: #{EPCB::escape(tmp)}"
      line = tmp.chomp
      row = CSV.parse_line(line, ?,, EPCB::CSV_LINE_SEP)
      # t@CǂݍłAŏ̌A
      # ܂͐Vɐ؂ւꍇ
      if /^\$\$(.+)/ =~ row[0]
        name = $1
        # Vɐ؂ւ
        if data_set != nil
          # ǂ݂At@C|C^ɖ߂Ă
          size = -(tmp.unpack("C*").size) - 1 # \r̕-1
          @src_file.seek(size, IO::SEEK_CUR)
          # [v𔲂āAdata_setԂ
          break
        end
        Log::voutln("Parsing sheet \"#{name}\".")

        # }X^V[g̏ꍇ
        if EPCB::master_sheet?(name)
          data_set = EPCB::MasterData.new
        # vt@XV[g̏ꍇ
        elsif EPCB::prefs_sheet?(name)
          data_set = EPCB::PreferencesData.new
        # f[^V[g炵̂̏ꍇ
        else
          data_set = EPCB::MonthData.new(name)
        end
      # f[^s̏ꍇ
      else
        # V[g݂ȂŁAf[^sɂȂ藈ԁBO𓊂ׂ?
        next if data_set.nil?
        Log::debugln("#{row.inspect}")
        parse_row(row, data_set)
      end
      # sItZbgCNg
      offset = offset + 1
      @line_offset = @line_offset + 1
    end
    #puts "offset = #{offset}, @line_offset = #{@line_offset}"
    return data_set
  end

  private
  # CSṼf[^s1s͂B
  # === ARGS
  # line:: CSV̍s
  # data_set:: ͌ʂi[邽߂MonthData
  def parse_row(row, data_set)
    if data_set.master?
      row.each do |col|
        data_set.use << EPCB::UseMasterData.new(col)
      end
    elsif data_set.prefs?
      raise(EPCB::InvalidCSVDataFormatError, "CSV's column size must be 2. (#{row.to_a.size})") if row.to_a.size != 2
      data_set.store(row[0], row[1])
    else
      raise(EPCB::InvalidCSVDataFormatError, "CSV's column size must be 4. (#{row.to_a.size})") if row.to_a.size != 4
      # CSṼf[^s"t,pr,z,l"ƂtH[}bg
      data = EPCB::new_specific_instance("IncomeExpensesData", nil, 
                                         EPCB::TARGET_VERSION, *row)
      data_set.add(data)
    end
  end

  def destroy
    begin
      @src_file.close unless @src_file.nil?
    rescue IOError
      # Ȃ
    end
  end
end #CSVParser#
