#
# == epcb/csv/csv-serializer
#
# Revision:: $Id$
#
require 'csv'
require 'epcb/csv/common'

#
# MonthDataCSVɏo͂SerializerB
#
class EPCB::CSV::CSVSerializer
  # RXgN^B
  # === ARGS
  # file:: f[^o͂FileIuWFNg
  def initialize(file)
    @dest_file = file
  end

  # +data_set+RXgN^ŗ^ꂽꏊCSVƂďo͂B
  # === ARGS
  # data_set:: CSVɏo͂f[^
  def serialize(data_set)
    CSV::Writer.generate(@dest_file, ?,, EPCB::CSV_LINE_SEP) do |csv|
      Log::voutln("Serializing sheet \"#{data_set.name}\"")
      # V[go
      csv << [ EPCB::CSV_SHEET_PREFIX + data_set.name ]
      if data_set.master?
        serialize_master(data_set, csv)
      elsif data_set.prefs?
        serialize_prefs(data_set, csv)
      else
        serialize_data(data_set, csv)
      end
      Log::voutln("Finished to serialize sheet \"#{data_set.name}\"\n")
    end
  end

  protected
  # ̃f[^V[gdata_seto͂B
  # === ARGS
  # data_set:: CSVɏo͂V[g̃f[^
  def serialize_data(data_set, csv)
    count = 0
    data_set.each do |data|
      Log::debugln("row[#{count}] = [#{data.to_a}]")
      # f[^o
      csv << data.to_a
      count += 1
    end
  end

  # ̃}X^V[gdata_seto͂B
  # === ARGS
  # data_set:: CSVɏo͂}X^V[g̃f[^
  def serialize_master(data_set, csv)
    Log::debugln("Use master = #{data_set.use.inspect}")
    columns = Array.new
    data_set.use.each do |use|
      columns << use.value
    end
    
    csv << columns
  end

  # ̃vt@XV[gdata_seto͂B
  # === ARGS
  # data_set:: CSVɏo͂}X^V[g̃f[^
  def serialize_prefs(data_set, csv)
    count = 0
    data_set.each do |name, value|
      Log::debugln("preference[#{count}] = { #{name} = #{value} }")
      # f[^o
      csv << [ name, value ]
      count += 1
    end
  end

end #EPCB::CSV::CSVSerializer#
