#!/usr/bin/env ruby

# == cli-test
# epcb-csv.{rb,exe}̃R}hCC^tF[X̃eXgB
#
# Revision:: $Id$
#
require 'optparse'
require 'ostruct'
require 'fileutils'
require 'epcb/csv/all-generator'
require 'epcb/test/cli/common'

$KCODE = "s"

parent_dir = File.expand_path(File.dirname($0))
$:.push(parent_dir)

$options = OpenStruct.new
$options.data_dir = File.join(File.dirname(File.dirname(parent_dir)), "test/data")
$options.program = "ruby epcb-csv.rb"
$options.remove_std = false
$options.tmp_dir = File.join(File.dirname(File.dirname(parent_dir)), "tmp")
$options.tmp_dir = "." unless FileTest.directory?($options.tmp_dir)

helper = nil
ARGV.options do |opts|
  helper = EPCB::Test::CLI::Helper.new($options)

  opts.banner = <<BANNER
Usage: #{File.basename($0)} [options]
BANNER
  opts.separator("")
  opts.separator("options are:")
  # --data-dir
  helper.define_data_dir(opts)
  # --tmp-dir
  helper.define_tmp_dir(opts)
  # --program
  helper.define_program(opts)
  # --remove
  helper.define_remove(opts)
  # --help
  helper.define_help(opts)

  # IvV̉
  opts.parse!
end

dir = File.expand_path($options.tmp_dir)
$out = File.open("#{dir}/stdout", "w")
$err = File.open("#{dir}/stderr", "w")

# _CNgt@C폜鏈o^
helper.register_at_exit([ $out, $err ])

# test/unitat_exitgp̂ŁArequire
require 'test/unit'
require 'epcb/test/cli/common'

class EPCB::Test::CLI::TestData
  attr_reader :_1_0_simple_data, :_1_0_simple_master_data, :_1_0_3sheets_data, \
  :_1_1_0_2sheets_data, :_1_1_0_2sheets_data

  def initialize
    @_1_0_simple_data = [
      ["$$2004N10"],
      ["2004/10/1","y","-14000",""],
      ["","H","-105",""],
      ["","","-270",""],
      ["2004/10/2","y","-2800",""],
      ["","H","-270",""],
      ["","","-270",""],
      ["2004/10/3","","-270",""],
      ["","H","-545",""],
      ["","H","-130",""],
      ["","","-8820",""],
      ["","pi","-1029",""],
      ["","H","-377",""],
      ["","","-270",""],
    ]

    @_1_0_simple_master_data = [
      "pr}X^","H","ʔ","۔","핞","y",""
    ]

    @_1_0_3sheets_data = [
      ["$$2004N8"],
      ["2004/8/1","y","-1279",""],
      ["","H","-315",""],
      ["","핞","-4095",""],
      ["","핞","-945",""],
      ["","","-270",""],
      ["","ϕi","-1525",""],
      ["2004/8/2","H","-204",""],
      ["","H","-147",""],
      ["","","-270",""],

      ["$$2004N9"],
      ["2004/9/1","","-540",""],
      ["","H","-100",""],
      ["","H","-1300",""],
      ["2004/9/2","H","-520",""],
      ["","H","-262",""],

      ["$$2004N10"],
      ["2004/10/1","y","-14000",""],
      ["","H","-105",""],
      ["","","-270",""],
      ["2004/10/2","y","-2800",""],
      ["","H","-270",""],
      ["","","-270",""],
    ]

    @_1_1_0_2sheets_data = [
      ["$$2005N2"],
      ["2005/2/1","y","-1500","2/1̔l"],
      ["","","-270",""],
      ["","i","-853",""],
      ["2005/2/2","H","-231",""],
      ["","","-270",""],
      ["","ʔ","-500","i<->l"],
      ["2003/2/3","Ɠdi","-40000",""],
      ["","ʔ","-320",""],
      ["","","-5250",""],

      ["$$2005N3"],
      ["2005/3/15","{EG","-1500",""],
      ["","y","-3000",""],
    ]
  end
end

#
# 1.0 -> 1.1̃eXgP[XB
#
class EPCB::Test::CLI::TestEPCBCSVError < Test::Unit::TestCase
  def initialize(name)
    super(name)
    @helper = EPCB::Test::CLI::TestCaseHelper.new($out, $err, $options.remove_std)
    @data = EPCB::Test::CLI::TestData.new
  end

  def test_arg_error
    expected = 110
    # TuR}hȂ
    @helper.putil.quiet_run($options.program, __FILE__, __LINE__)
    assert_equal(expected, @helper.putil.exit_status)

    # sȃTuR}h
    @helper.putil.quiet_run("#{$options.program} hoge", __FILE__, __LINE__)
    assert_equal(expected, @helper.putil.exit_status)

    # src_fileȂ
    @helper.putil.quiet_run("#{$options.program} gencsv", __FILE__, __LINE__)
    assert_equal(expected, @helper.putil.exit_status)
  end

  def test_gencsv_error
    # src_file݂Ȃ
    @helper.putil.quiet_run("#{$options.program} gencsv not_found.xls",
                            __FILE__, __LINE__)
    assert_equal(121, @helper.putil.exit_status)

    # -tŎw肳ꂽt@C݂Ȃ
    @helper.putil.quiet_run("#{$options.program} genall" \
                            " #{$options.data_dir}/1_0_simple.xls" \
                            " -t #{$options.data_dir}/not_found.xls" \
                            " -o #{$options.tmp_dir}/test_unknown_version.xls",
                            __FILE__, __LINE__)
    assert_equal(121, @helper.putil.exit_status)
    
    # -oŎw肳ꂽt@Cǎp(Errno::EACCESS)
    @helper.putil.quiet_run("#{$options.program} gencsv" \
                            " #{$options.data_dir}/1_0_simple.xls" \
                            " -o #{$options.data_dir}/read_only.csv",
                            __FILE__, __LINE__)
    assert_equal(120, @helper.putil.exit_status)

    # Lgenall
    @helper.putil.quiet_run("#{$options.program} genall" \
                            " #{$options.data_dir}/1_0_simple.xls" \
                            " -t #{$options.data_dir}/ExcelPettyCashBook-1.1.1.xls" \
                            " -o #{$options.data_dir}/read_only.xls",
                            __FILE__, __LINE__)
    assert_equal(120, @helper.putil.exit_status)

    # -oŎw肳ꂽpX݂Ȃ(Errno::ENOENT)
    @helper.putil.quiet_run("#{$options.program} gencsv" \
                            " #{$options.data_dir}/1_0_simple.xls" \
                            " -o #{$options.data_dir}/no_path/read_only.csv -V",
                            __FILE__, __LINE__)
    assert_equal(121, @helper.putil.exit_status)

    # src_filefBNg
    @helper.putil.quiet_run("#{$options.program} gencsv #{File.dirname($0)}",
                            __FILE__, __LINE__)
    assert_equal(123, @helper.putil.exit_status)

    # ͂CSVt@C̃Js
    @helper.putil.quiet_run("#{$options.program} genexcel" \
                            " #{$options.data_dir}/illegal_column_size.csv" \
                            " -t #{$options.data_dir}/ExcelPettyCashBook-1.1.1.xls" \
                            " -o #{$options.tmp_dir}/illegal_column_size.xls",
                            __FILE__, __LINE__)
    assert_equal(130, @helper.putil.exit_status)

    # genall-tw肳ĂȂ
    @helper.putil.quiet_run("#{$options.program} genexcel" \
                            " #{$options.data_dir}/illegal_column_size.csv" \
                            " -o #{$options.tmp_dir}/illegal_column_size.xls -V",
                            __FILE__, __LINE__)
    assert_equal(111, @helper.putil.exit_status)

    # -S̃o[Ws
    @helper.putil.quiet_run("#{$options.program} gencsv -S 10.10.10" \
                            " #{$options.data_dir}/nodata.xls",
                            __FILE__, __LINE__)
    assert_equal(110, @helper.putil.exit_status)

    # -tŎw肳ꂽExcelPettyCashBook̃o[Ws
    @helper.putil.quiet_run("#{$options.program} genall" \
                            " #{$options.data_dir}/1_0_simple.xls" \
                            " -t #{$options.data_dir}/unknown_version.xls" \
                            " -o #{$options.tmp_dir}/test_unknown_version.xls -V",
                            __FILE__, __LINE__)
    assert_equal(140, @helper.putil.exit_status)
  end
end

#
# 1.0 -> 1.1̃eXgP[XB
#
class EPCB::Test::CLI::TestEPCBCSV_1_0 < Test::Unit::TestCase

  def initialize(name)
    super(name)
    @helper = EPCB::Test::CLI::TestCaseHelper.new($out, $err, $options.remove_std)
    @data = EPCB::Test::CLI::TestData.new
  end

  #
  # V[g1̃f[^(1_0_simple.xls)
  #
  def test_gencsv_1_0_simple
    @helper.gencsv_and_validate_csv("1_0_simple", @data._1_0_simple_data)

    # }X^V[gCSVɏo͂ꍇ̃eXg
    expected = @data._1_0_simple_data.dup
    expected.unshift(@data._1_0_simple_master_data.dup)
    expected.unshift(["$$}X^"])
    @helper.gencsv_and_validate_csv("1_0_simple", expected, "-m")
  end

  #
  # V[g3̃f[^(1_0_3sheets.xls)
  #
  def test_gencsv_1_0_3sheets
    @helper.gencsv_and_validate_csv("1_0_3sheets", @data._1_0_3sheets_data)
  end

  #
  # genall̃eXg
  #
  def test_genall_1_0_to_1_1
    _1_0_validate_proc = Proc.new do |data, line, column|
      puts "L#{line} C#{column}: #{@helper.eutil.get_offset(line, column).value.inspect}"
      # dataexcelł́AL̂悤2Ԗڈȍ~̃ItZbgقȂ邽߁A
      # column2ȏ̂̂͂炷Ă
      # data : [ t,       pr, z  ]
      # excel: [ t, j, pr, z, l ] 

      # t
      if column == 0
        next if data[line][column] == ""
        value = @helper.eutil.get_offset(line, column).value.to_s
        date = EPCB::ExcelUtil.to_yyyymmdd_format(value)
        assert_equal(data[line][column], date)
      # pr
      elsif column == 2
        assert_equal(data[line][column-1],
                     @helper.eutil.get_offset(line, column).value.to_s)
      # z
      elsif column == 3
        assert_equal(data[line][column-1].to_i,
                     @helper.eutil.get_offset(line, column).value.to_i)
      # l(1.0ڍsꍇKnilȂ͂)
      elsif column == 6
        assert_nil(@helper.eutil.get_offset(line, column).value)
      end
    end
    
    name = "1_0_simple"
    template = "ExcelPettyCashBook-1.1.0.xls"
    outfile = "#{$options.tmp_dir}/#{name}_NEW.xls"
    @helper.genall_and_validate_excel(name, template, outfile,
                                     @data._1_0_simple_data, &_1_0_validate_proc)

    # -m ꍇ̃eXg
    @helper.run_command("genall", name,
                        "-t #{$options.data_dir}/#{template} -o #{outfile} -m")
    assert(FileTest.exist?(outfile))
    dest_path = File.file_system.getAbsolutePathName(outfile)
    begin
      workbook = @helper.eutil.open_workbook_and_activate(dest_path)
      master = workbook.worksheets(3)
      for i in 0 .. @data._1_0_simple_master_data.size - 1
        assert_equal(@data._1_0_simple_master_data[i], master.cells(i + 1, 1).value.to_s)
      end
      assert_nil(master.cells(@data._1_0_simple_master_data.size + 1, 1).value)
    ensure
      @helper.eutil.destroy_excel
    end
    
    name = "1_0_3sheets"
    outfile = "#{$options.tmp_dir}/#{name}_NEW.xls"
    @helper.genall_and_validate_excel(name, template, outfile,
                                      @data._1_0_3sheets_data, &_1_0_validate_proc)
  end #test_genall_1_0_to_1_1#

  #
  # 1.1.0->1.1.1genall̃eXg
  #
  def test_genall_1_1_0_to_1_1_1
    _1_1_validate_proc = Proc.new do |data, line, column|
      puts "L#{line} C#{column}: #{@helper.eutil.get_offset(line, column).value.inspect}"
      # dataexcelł́AL̂悤2Ԗڈȍ~̃ItZbgقȂ邽߁A
      # column2ȏ̂̂͂炷Ă
      # data : [ t,       pr, z  ]
      # excel: [ t, j, pr, z, l ] 

      # t
      if column == 0
        #next if data[line][column] == ""
        value = @helper.eutil.get_offset(line, column).value.to_s
        date = EPCB::ExcelUtil.to_yyyymmdd_format(value)
        assert_equal(data[line][column], date)
      # pr
      elsif column == 2
        assert_equal(data[line][column-1],
                     @helper.eutil.get_offset(line, column).value.to_s)
      # z
      elsif column == 3
        assert_equal(data[line][column-1].to_i,
                     @helper.eutil.get_offset(line, column).value.to_i)
      # l
      elsif column == 6
        assert_equal(data[line][column-1],
                     @helper.eutil.get_offset(line, column).value.to_s)
      end
    end
    
    name = "1_1_0_2sheets"
    template = "ExcelPettyCashBook-1.1.1.xls"
    outfile = "#{$options.tmp_dir}/#{name}_NEW.xls"
    @helper.genall_and_validate_excel(name, template, outfile,
                                      @data._1_1_0_2sheets_data, &_1_1_validate_proc)

  end #test_genall_1_1_to_1_1#

end
