/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class FormTag
extends TagSupport {
    protected String action = null;
    protected ModuleConfig moduleConfig = null;
    protected String enctype = null;
    protected String focus = null;
    protected String focusIndex = null;
    protected static String lineEnd = System.getProperty("line.separator");
    protected ActionMapping mapping = null;
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected String method = null;
    protected String onreset = null;
    protected String onsubmit = null;
    protected boolean scriptLanguage = true;
    protected ActionServlet servlet = null;
    protected String style = null;
    protected String styleClass = null;
    protected String styleId = null;
    protected String target = null;
    protected String beanName = null;
    protected String beanScope = null;
    protected String beanType = null;
    protected String acceptCharset = null;

    public String getBeanName() {
        return this.beanName;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public String getFocus() {
        return this.focus;
    }

    public void setFocus(String focus) {
        this.focus = focus;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getOnreset() {
        return this.onreset;
    }

    public void setOnreset(String onReset) {
        this.onreset = onReset;
    }

    public String getOnsubmit() {
        return this.onsubmit;
    }

    public void setOnsubmit(String onSubmit) {
        this.onsubmit = onSubmit;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getAcceptCharset() {
        return this.acceptCharset;
    }

    public void setAcceptCharset(String acceptCharset) {
        this.acceptCharset = acceptCharset;
    }

    public int doStartTag() throws JspException {
        this.lookup();
        StringBuffer results = new StringBuffer();
        results.append(this.renderFormStartElement());
        results.append(this.renderToken());
        TagUtils.getInstance().write(this.pageContext, results.toString());
        this.pageContext.setAttribute("org.apache.struts.taglib.html.FORM", (Object)this, 2);
        this.initFormBean();
        return 1;
    }

    protected void initFormBean() throws JspException {
        Object bean;
        int scope = 3;
        if ("request".equalsIgnoreCase(this.beanScope)) {
            scope = 2;
        }
        if ((bean = this.pageContext.getAttribute(this.beanName, scope)) == null) {
            bean = RequestUtils.createActionForm((HttpServletRequest)this.pageContext.getRequest(), this.mapping, this.moduleConfig, this.servlet);
            if (bean instanceof ActionForm) {
                ((ActionForm)bean).reset(this.mapping, (HttpServletRequest)this.pageContext.getRequest());
            }
            if (bean == null) {
                throw new JspException(messages.getMessage("formTag.create", (Object)this.beanType));
            }
            this.pageContext.setAttribute(this.beanName, bean, scope);
        }
        this.pageContext.setAttribute("org.apache.struts.taglib.html.BEAN", bean, 2);
    }

    protected String renderFormStartElement() {
        StringBuffer results = new StringBuffer("<form");
        this.renderName(results);
        this.renderAttribute(results, "method", this.getMethod() == null ? "post" : this.getMethod());
        this.renderAction(results);
        this.renderAttribute(results, "accept-charset", this.getAcceptCharset());
        this.renderAttribute(results, "class", this.getStyleClass());
        this.renderAttribute(results, "enctype", this.getEnctype());
        this.renderAttribute(results, "onreset", this.getOnreset());
        this.renderAttribute(results, "onsubmit", this.getOnsubmit());
        this.renderAttribute(results, "style", this.getStyle());
        this.renderAttribute(results, "id", this.getStyleId());
        this.renderAttribute(results, "target", this.getTarget());
        this.renderOtherAttributes(results);
        results.append(">");
        return results.toString();
    }

    protected void renderName(StringBuffer results) {
        results.append(" name=\"");
        results.append(this.beanName);
        results.append("\"");
    }

    protected void renderAction(StringBuffer results) {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        results.append(" action=\"");
        results.append(response.encodeURL(TagUtils.getInstance().getActionMappingURL(this.action, this.pageContext)));
        results.append("\"");
    }

    protected void renderOtherAttributes(StringBuffer results) {
    }

    protected String renderToken() {
        String token;
        StringBuffer results = new StringBuffer();
        HttpSession session = this.pageContext.getSession();
        if (session != null && (token = (String)session.getAttribute("org.apache.struts.action.TOKEN")) != null) {
            results.append("<input type=\"hidden\" name=\"");
            results.append("org.apache.struts.taglib.html.TOKEN");
            results.append("\" value=\"");
            results.append(token);
            if (this.isXhtml()) {
                results.append("\" />");
            } else {
                results.append("\">");
            }
        }
        return results.toString();
    }

    protected void renderAttribute(StringBuffer results, String attribute, String value) {
        if (value != null) {
            results.append(" ");
            results.append(attribute);
            results.append("=\"");
            results.append(value);
            results.append("\"");
        }
    }

    public int doEndTag() throws JspException {
        this.pageContext.removeAttribute("org.apache.struts.taglib.html.BEAN", 2);
        this.pageContext.removeAttribute("org.apache.struts.taglib.html.FORM", 2);
        StringBuffer results = new StringBuffer("</form>");
        if (this.focus != null) {
            results.append(this.renderFocusJavascript());
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(results.toString());
        }
        catch (IOException e) {
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 6;
    }

    protected String renderFocusJavascript() {
        StringBuffer results = new StringBuffer();
        results.append(lineEnd);
        results.append("<script type=\"text/javascript\"");
        if (!this.isXhtml() && this.scriptLanguage) {
            results.append(" language=\"JavaScript\"");
        }
        results.append(">");
        results.append(lineEnd);
        if (!this.isXhtml()) {
            results.append("  <!--");
            results.append(lineEnd);
        }
        StringBuffer focusControl = new StringBuffer("document.forms[\"");
        focusControl.append(this.beanName);
        focusControl.append("\"].elements[\"");
        focusControl.append(this.focus);
        focusControl.append("\"]");
        results.append("  var focusControl = ");
        results.append(focusControl.toString());
        results.append(";");
        results.append(lineEnd);
        results.append(lineEnd);
        results.append("  if (focusControl.type != \"hidden\" && !focusControl.disabled) {");
        results.append(lineEnd);
        String index = "";
        if (this.focusIndex != null) {
            StringBuffer sb = new StringBuffer("[");
            sb.append(this.focusIndex);
            sb.append("]");
            index = sb.toString();
        }
        results.append("     focusControl");
        results.append(index);
        results.append(".focus();");
        results.append(lineEnd);
        results.append("  }");
        results.append(lineEnd);
        if (!this.isXhtml()) {
            results.append("  // -->");
            results.append(lineEnd);
        }
        results.append("</script>");
        results.append(lineEnd);
        return results.toString();
    }

    public void release() {
        super.release();
        this.action = null;
        this.moduleConfig = null;
        this.enctype = null;
        this.focus = null;
        this.focusIndex = null;
        this.mapping = null;
        this.method = null;
        this.onreset = null;
        this.onsubmit = null;
        this.servlet = null;
        this.style = null;
        this.styleClass = null;
        this.styleId = null;
        this.target = null;
        this.acceptCharset = null;
    }

    protected void lookup() throws JspException {
        this.moduleConfig = TagUtils.getInstance().getModuleConfig(this.pageContext);
        if (this.moduleConfig == null) {
            JspException e = new JspException(messages.getMessage("formTag.collections"));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        this.servlet = (ActionServlet)((Object)this.pageContext.getServletContext().getAttribute("org.apache.struts.action.ACTION_SERVLET"));
        String mappingName = TagUtils.getInstance().getActionMappingName(this.action);
        this.mapping = (ActionMapping)this.moduleConfig.findActionConfig(mappingName);
        if (this.mapping == null) {
            JspException e = new JspException(messages.getMessage("formTag.mapping", (Object)mappingName));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        FormBeanConfig formBeanConfig = this.moduleConfig.findFormBeanConfig(this.mapping.getName());
        if (formBeanConfig == null) {
            JspException e = new JspException(messages.getMessage("formTag.formBean", (Object)this.mapping.getName(), (Object)this.action));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        this.beanName = this.mapping.getAttribute();
        this.beanScope = this.mapping.getScope();
        this.beanType = formBeanConfig.getType();
    }

    private boolean isXhtml() {
        return TagUtils.getInstance().isXhtml(this.pageContext);
    }

    public String getFocusIndex() {
        return this.focusIndex;
    }

    public void setFocusIndex(String focusIndex) {
        this.focusIndex = focusIndex;
    }

    public boolean getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(boolean scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }
}

