/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.GroupRequest;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;

public abstract class AbstractStrutsConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionBendpointEditPolicy());
    }

    public void activate() {
        super.activate();
        ((AbstractModel)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        ((AbstractModel)this.getModel()).removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private class EntityComponentEditPolicy
    extends ComponentEditPolicy {
        EntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setModel((AbstractConnectionModel)AbstractStrutsConnectionEditPart.this.getModel());
            return command;
        }
    }

    private class DeleteCommand
    extends Command {
        private AbstractConnectionModel model;

        DeleteCommand() {
        }

        public void setModel(AbstractConnectionModel model) {
            this.model = model;
        }

        public void execute() {
            this.model.detachSource();
            this.model.detachTarget();
        }
    }

    private class ConnectionBendpointEditPolicy
    extends BendpointEditPolicy {
        ConnectionBendpointEditPolicy() {
        }

        protected Command getCreateBendpointCommand(BendpointRequest request) {
            Point point = request.getLocation();
            this.getConnection().translateToRelative((Translatable)point);
            CreateBendpointCommand command = new CreateBendpointCommand();
            command.setLocation(point);
            command.setConnection(AbstractStrutsConnectionEditPart.this.getModel());
            command.setIndex(request.getIndex());
            return command;
        }

        protected Command getDeleteBendpointCommand(BendpointRequest request) {
            DeleteBendpointCommand command = new DeleteBendpointCommand();
            command.setConnectionModel(this.getHost().getModel());
            command.setIndex(request.getIndex());
            return command;
        }

        protected Command getMoveBendpointCommand(BendpointRequest request) {
            Point location = request.getLocation();
            this.getConnection().translateToRelative((Translatable)location);
            MoveBendpointCommand command = new MoveBendpointCommand();
            command.setConnectionModel(this.getHost().getModel());
            command.setIndex(request.getIndex());
            command.setNewLocation(location);
            return command;
        }
    }

    public class CreateBendpointCommand
    extends Command {
        private AbstractConnectionModel connection;
        private Point location;
        private int index;

        public void execute() {
            this.connection.addBendpoint(this.index, this.location);
        }

        public void setConnection(Object model) {
            this.connection = (AbstractConnectionModel)model;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void setLocation(Point point) {
            this.location = point;
        }

        public void undo() {
            this.connection.removeBendpoint(this.index);
        }
    }

    private class MoveBendpointCommand
    extends Command {
        private AbstractConnectionModel connection;
        private Point oldLocation;
        private Point newLocation;
        private int index;

        MoveBendpointCommand() {
        }

        public void execute() {
            this.oldLocation = (Point)this.connection.getBendpoints().get(this.index);
            this.connection.replaceBendpoint(this.index, this.newLocation);
        }

        public void setConnectionModel(Object model) {
            this.connection = (AbstractConnectionModel)model;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void setNewLocation(Point point) {
            this.newLocation = point;
        }

        public void undo() {
            this.connection.replaceBendpoint(this.index, this.oldLocation);
        }
    }

    private class DeleteBendpointCommand
    extends Command {
        private AbstractConnectionModel connection;
        private Point oldLocation;
        private int index;

        DeleteBendpointCommand() {
        }

        public void execute() {
            this.oldLocation = (Point)this.connection.getBendpoints().get(this.index);
            this.connection.removeBendpoint(this.index);
        }

        public void setConnectionModel(Object model) {
            this.connection = (AbstractConnectionModel)model;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void undo() {
            this.connection.addBendpoint(this.index, this.oldLocation);
        }
    }
}

