/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import org.eclipse.core.resources.IFile;
import tk.eclipse.plugin.struts.FormInfo;
import tk.eclipse.plugin.struts.PropertyInfo;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.validator.AbstractStrutsXMLValidator;

public class ValidatorValidator
extends AbstractStrutsXMLValidator {
    private FormInfo[] forms;

    public ValidatorValidator(StrutsProject project, IFile file) {
        super(project, file);
    }

    protected void executeValidate() {
        try {
            this.forms = this.project.getActionForms();
            this.validateElement(this.doc.getDocumentElement());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateElement(FuzzyXMLElement element) {
        try {
            String property;
            FuzzyXMLElement parent;
            String form;
            String name;
            FuzzyXMLAttribute attr;
            if (element.getName().equals("form") && (attr = element.getAttributeNode("name")) != null && !this.existsForm(name = attr.getValue())) {
                this.createAttributeValueMarker(attr, Util.createMessage(StrutsPlugin.getResourceString("error.noActionForm"), new String[]{name}));
                return;
            }
            if (element.getName().equals("field") && (attr = element.getAttributeNode("property")) != null && !this.existsProperty(form = (parent = (FuzzyXMLElement)element.getParentNode()).getAttributeNode("name").getValue(), property = attr.getValue())) {
                this.createAttributeValueMarker(attr, Util.createMessage(StrutsPlugin.getResourceString("error.noProperty"), new String[]{form, property}));
                return;
            }
        }
        catch (Exception attr) {
            // empty catch block
        }
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)children[i]);
            }
            ++i;
        }
    }

    private boolean existsForm(String name) {
        int i = 0;
        while (i < this.forms.length) {
            if (this.forms[i].getFormName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean existsProperty(String name, String property) {
        int i = 0;
        while (i < this.forms.length) {
            if (this.forms[i].getFormName().equals(name)) {
                PropertyInfo[] props = this.forms[i].getProperties();
                int j = 0;
                while (j < props.length) {
                    if (props[j].getPropertyName().equals(property)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }
}

