/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCDATAImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCommentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocTypeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocumentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLElementImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLProcessingInstructionImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLTextImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.resources.Messages;

public class FuzzyXMLParser {
    private Stack stack = new Stack();
    private String originalSource;
    private FuzzyXMLElementImpl root;
    private FuzzyXMLDocType docType;
    private ArrayList listeners = new ArrayList();
    private ArrayList nonCloseElement = new ArrayList();
    private Pattern tag = Pattern.compile("<((|/)([^<>]*))([^<]|>)");
    private Pattern attr = Pattern.compile("([\\w:]+?)\\s*=(\"|')([^\"]*?)\\2");
    private Pattern docTypeName = Pattern.compile("^<!DOCTYPE[ \r\n\t]+([\\w\\-_]*)");
    private Pattern docTypePublic = Pattern.compile("PUBLIC[ \r\n\t]+\"(.*?)\"[ \r\n\t]+\"(.*?)\"");
    private Pattern docTypeSystem = Pattern.compile("SYSTEM[ \r\n\t]+\"(.*?)\"");
    private Pattern docTypeSubset = Pattern.compile("\\[([^\\]]*)\\]>");

    public void addErrorListener(FuzzyXMLErrorListener fuzzyXMLErrorListener) {
        this.listeners.add(fuzzyXMLErrorListener);
    }

    private void fireErrorEvent(int n, int n2, String string, FuzzyXMLNode fuzzyXMLNode) {
        FuzzyXMLErrorEvent fuzzyXMLErrorEvent = new FuzzyXMLErrorEvent(n, n2, string, fuzzyXMLNode);
        for (int i = 0; i < this.listeners.size(); ++i) {
            FuzzyXMLErrorListener fuzzyXMLErrorListener = (FuzzyXMLErrorListener)this.listeners.get(i);
            fuzzyXMLErrorListener.error(fuzzyXMLErrorEvent);
        }
    }

    public FuzzyXMLDocument parse(InputStream inputStream) throws IOException {
        byte[] byArray = FuzzyXMLUtil.readStream(inputStream);
        String string = FuzzyXMLUtil.getEncoding(byArray);
        if (string == null) {
            return this.parse(new String(byArray));
        }
        return this.parse(new String(byArray, string));
    }

    public FuzzyXMLDocument parse(File file) throws IOException {
        byte[] byArray = FuzzyXMLUtil.readStream(new FileInputStream(file));
        String string = FuzzyXMLUtil.getEncoding(byArray);
        if (string == null) {
            return this.parse(new String(byArray));
        }
        return this.parse(new String(byArray, string));
    }

    public FuzzyXMLDocument parse(String string) {
        Object object;
        this.originalSource = string;
        string = FuzzyXMLUtil.comment2space(string, true);
        string = FuzzyXMLUtil.escapeScript(string);
        string = FuzzyXMLUtil.cdata2space(string, true);
        string = FuzzyXMLUtil.doctype2space(string, true);
        string = FuzzyXMLUtil.processing2space(string, true);
        string = FuzzyXMLUtil.escapeString(string);
        Matcher matcher = this.tag.matcher(string);
        int n = -1;
        while (matcher.find()) {
            if (n != -1 && n < matcher.start()) {
                this.handleText(n, matcher.start());
            }
            if (((String)(object = matcher.group(1).trim())).startsWith("?")) {
                this.handleDeclaration(matcher.start(), matcher.end());
            } else if (((String)object).startsWith("!DOCTYPE") || ((String)object).startsWith("!doctype")) {
                this.handleDoctype(matcher.start(), matcher.end(), (String)object);
            } else if (((String)object).startsWith("![CDATA[")) {
                this.handleCDATA(matcher.start(), matcher.end(), this.originalSource.substring(matcher.start(), matcher.end()));
            } else if (((String)object).startsWith("/")) {
                this.handleCloseTag(matcher.start(), matcher.end(), (String)object);
            } else if (((String)object).startsWith("!--")) {
                this.handleComment(matcher.start(), matcher.end(), this.originalSource.substring(matcher.start(), matcher.end()));
            } else if (((String)object).endsWith("/")) {
                this.handleEmptyTag(matcher.start(), matcher.end());
            } else {
                this.handleStartTag(matcher.start(), matcher.end());
            }
            n = matcher.end();
        }
        object = null;
        if (this.root == null) {
            object = new FuzzyXMLElementImpl(null, "document", 0, this.originalSource.length());
        } else {
            object = new FuzzyXMLElementImpl(null, "document", this.root.getOffset(), this.root.getLength());
            object.appendChild(this.root);
        }
        return new FuzzyXMLDocumentImpl((FuzzyXMLElement)object, this.docType);
    }

    private void handleCDATA(int n, int n2, String string) {
        if (this.getParent() != null) {
            string = string.replaceFirst("<!\\[CDATA\\[", "");
            string = string.replaceFirst("\\]\\]>", "");
            FuzzyXMLCDATAImpl fuzzyXMLCDATAImpl = new FuzzyXMLCDATAImpl(this.getParent(), string, n, n2 - n);
            ((FuzzyXMLElement)this.getParent()).appendChild(fuzzyXMLCDATAImpl);
        }
    }

    private void handleText(int n, int n2) {
        String string = this.originalSource.substring(n, n2);
        if (this.getParent() != null) {
            FuzzyXMLTextImpl fuzzyXMLTextImpl = new FuzzyXMLTextImpl(this.getParent(), FuzzyXMLUtil.decode(string), n, n2 - n);
            ((FuzzyXMLElement)this.getParent()).appendChild(fuzzyXMLTextImpl);
        }
    }

    private void handleDeclaration(int n, int n2) {
        if (this.getParent() != null) {
            String string = this.originalSource.substring(n, n2);
            string = string.replaceFirst("^<\\?", "");
            string = string.replaceFirst("\\?>$", "");
            string = string.trim();
            String[] stringArray = string.split("[ \r\n\t]+");
            String string2 = stringArray[0];
            String string3 = string.substring(string2.length()).trim();
            FuzzyXMLProcessingInstructionImpl fuzzyXMLProcessingInstructionImpl = new FuzzyXMLProcessingInstructionImpl(null, string2, string3, n, n2 - n);
            ((FuzzyXMLElement)this.getParent()).appendChild(fuzzyXMLProcessingInstructionImpl);
        }
    }

    private void handleDoctype(int n, int n2, String string) {
        if (this.docType == null) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            string = this.originalSource.substring(n, n2);
            Matcher matcher = this.docTypeName.matcher(string);
            if (matcher.find()) {
                string2 = matcher.group(1);
            }
            if ((matcher = this.docTypePublic.matcher(string)).find()) {
                string3 = matcher.group(1);
                string4 = matcher.group(2);
            } else {
                matcher = this.docTypeSystem.matcher(string);
                if (matcher.find()) {
                    string4 = matcher.group(1);
                }
            }
            matcher = this.docTypeSubset.matcher(string);
            if (matcher.find()) {
                string5 = matcher.group(1);
            }
            this.docType = new FuzzyXMLDocTypeImpl(null, string2, string3, string4, string5, n, n2 - n);
        }
    }

    private void handleCloseTag(int n, int n2, String string) {
        if (this.stack.size() == 0) {
            return;
        }
        String string2 = string.substring(1).trim();
        FuzzyXMLElementImpl fuzzyXMLElementImpl = (FuzzyXMLElementImpl)this.stack.pop();
        if (!fuzzyXMLElementImpl.getName().toLowerCase().equals(string2.toLowerCase())) {
            if (fuzzyXMLElementImpl.getParentNode() != null) {
                ((FuzzyXMLElement)fuzzyXMLElementImpl.getParentNode()).appendChild(fuzzyXMLElementImpl);
                FuzzyXMLNode[] fuzzyXMLNodeArray = fuzzyXMLElementImpl.getChildren();
                for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
                    ((AbstractFuzzyXMLNode)fuzzyXMLNodeArray[i]).setParentNode(fuzzyXMLElementImpl.getParentNode());
                    fuzzyXMLElementImpl.removeChild(fuzzyXMLNodeArray[i]);
                    ((FuzzyXMLElement)fuzzyXMLElementImpl.getParentNode()).appendChild(fuzzyXMLNodeArray[i]);
                }
            } else {
                this.fireErrorEvent(n, n2 - n, Messages.getMessage("error.noStartTag", string2), null);
            }
            this.handleCloseTag(n, n2, string);
            return;
        }
        fuzzyXMLElementImpl.setLength(n2 - fuzzyXMLElementImpl.getOffset());
        this.nonCloseElement.remove(fuzzyXMLElementImpl);
        if (fuzzyXMLElementImpl.getParentNode() == null) {
            this.root = fuzzyXMLElementImpl;
            for (int i = 0; i < this.nonCloseElement.size(); ++i) {
                FuzzyXMLElement fuzzyXMLElement = (FuzzyXMLElement)this.nonCloseElement.get(i);
                this.fireErrorEvent(fuzzyXMLElement.getOffset(), fuzzyXMLElement.getLength(), Messages.getMessage("error.noCloseTag", fuzzyXMLElement.getName()), fuzzyXMLElement);
            }
        } else {
            ((FuzzyXMLElement)fuzzyXMLElementImpl.getParentNode()).appendChild(fuzzyXMLElementImpl);
        }
    }

    private void handleEmptyTag(int n, int n2) {
        TagInfo tagInfo = this.parseTagContents(this.originalSource.substring(n + 1, n2 - 1));
        FuzzyXMLNode fuzzyXMLNode = this.getParent();
        FuzzyXMLElementImpl fuzzyXMLElementImpl = new FuzzyXMLElementImpl(fuzzyXMLNode, tagInfo.name, n, n2 - n);
        if (fuzzyXMLNode == null) {
            this.root = fuzzyXMLElementImpl;
        } else {
            ((FuzzyXMLElement)fuzzyXMLNode).appendChild(fuzzyXMLElementImpl);
        }
        AttrInfo[] attrInfoArray = tagInfo.getAttrs();
        for (int i = 0; i < attrInfoArray.length; ++i) {
            FuzzyXMLAttributeImpl fuzzyXMLAttributeImpl = new FuzzyXMLAttributeImpl(fuzzyXMLElementImpl, attrInfoArray[i].name, attrInfoArray[i].value, attrInfoArray[i].offset + n, attrInfoArray[i].end - attrInfoArray[i].offset + 1);
            fuzzyXMLElementImpl.appendChild(fuzzyXMLAttributeImpl);
        }
    }

    private void handleComment(int n, int n2, String string) {
        if (this.getParent() != null) {
            string = string.replaceFirst("<!--", "");
            string = string.replaceFirst("-->", "");
            FuzzyXMLCommentImpl fuzzyXMLCommentImpl = new FuzzyXMLCommentImpl(this.getParent(), string, n, n2 - n);
            ((FuzzyXMLElement)this.getParent()).appendChild(fuzzyXMLCommentImpl);
        }
    }

    private void handleStartTag(int n, int n2) {
        TagInfo tagInfo = this.parseTagContents(this.originalSource.substring(n + 1, n2 - 1));
        FuzzyXMLElementImpl fuzzyXMLElementImpl = new FuzzyXMLElementImpl(this.getParent(), tagInfo.name, n, n2 - n);
        AttrInfo[] attrInfoArray = tagInfo.getAttrs();
        for (int i = 0; i < attrInfoArray.length; ++i) {
            FuzzyXMLAttributeImpl fuzzyXMLAttributeImpl = new FuzzyXMLAttributeImpl(fuzzyXMLElementImpl, attrInfoArray[i].name, attrInfoArray[i].value, attrInfoArray[i].offset + n, attrInfoArray[i].end - attrInfoArray[i].offset + 1);
            fuzzyXMLElementImpl.appendChild(fuzzyXMLAttributeImpl);
        }
        this.stack.push(fuzzyXMLElementImpl);
        this.nonCloseElement.add(fuzzyXMLElementImpl);
    }

    private FuzzyXMLNode getParent() {
        if (this.stack.size() == 0) {
            return null;
        }
        return (FuzzyXMLNode)this.stack.get(this.stack.size() - 1);
    }

    private TagInfo parseTagContents(String string) {
        if ((string = string.trim()).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        TagInfo tagInfo = new TagInfo();
        if (FuzzyXMLUtil.getSpaceIndex(string) != -1) {
            tagInfo.name = string.substring(0, FuzzyXMLUtil.getSpaceIndex(string)).trim();
            this.parseAttributeContents(tagInfo, string);
        } else {
            tagInfo.name = string;
        }
        return tagInfo;
    }

    private void parseAttributeContents(TagInfo tagInfo, String string) {
        Matcher matcher = this.attr.matcher(string);
        while (matcher.find()) {
            AttrInfo attrInfo = new AttrInfo();
            attrInfo.name = matcher.group(1);
            attrInfo.value = FuzzyXMLUtil.decode(matcher.group(3));
            attrInfo.offset = matcher.start();
            attrInfo.end = matcher.end();
            tagInfo.addAttr(attrInfo);
        }
    }

    private class AttrInfo {
        private String name;
        private String value;
        private int offset;
        private int end;

        private AttrInfo() {
        }
    }

    private class TagInfo {
        private String name;
        private ArrayList attrs = new ArrayList();

        private TagInfo() {
        }

        public void addAttr(AttrInfo attrInfo) {
            AttrInfo[] attrInfoArray = this.getAttrs();
            for (int i = 0; i < attrInfoArray.length; ++i) {
                if (!attrInfoArray[i].name.equals(attrInfo.name)) continue;
                return;
            }
            this.attrs.add(attrInfo);
        }

        public AttrInfo[] getAttrs() {
            return this.attrs.toArray(new AttrInfo[this.attrs.size()]);
        }
    }
}

