/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.ArrayList;
import java.util.HashMap;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;

public class FuzzyXMLElementImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLElement {
    private ArrayList children = new ArrayList();
    private ArrayList attributes = new ArrayList();
    private String name;
    private HashMap namespace = new HashMap();

    public FuzzyXMLElementImpl(String string) {
        this(null, string, -1, -1);
    }

    public FuzzyXMLElementImpl(FuzzyXMLNode fuzzyXMLNode, String string, int n, int n2) {
        super(fuzzyXMLNode, n, n2);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void appendChild(FuzzyXMLNode fuzzyXMLNode) {
        AbstractFuzzyXMLNode abstractFuzzyXMLNode = (AbstractFuzzyXMLNode)fuzzyXMLNode;
        abstractFuzzyXMLNode.setParentNode(this);
        abstractFuzzyXMLNode.setDocument(this.getDocument());
        if (fuzzyXMLNode instanceof FuzzyXMLAttribute) {
            this.setAttribute((FuzzyXMLAttribute)fuzzyXMLNode);
        } else {
            if (this.children.contains(fuzzyXMLNode)) {
                return;
            }
            if (this.getDocument() == null) {
                this.children.add(fuzzyXMLNode);
                return;
            }
            FuzzyXMLNode[] fuzzyXMLNodeArray = this.getChildren();
            int n = 0;
            if (fuzzyXMLNodeArray.length == 0) {
                int n2 = this.getLength();
                FuzzyXMLAttribute[] fuzzyXMLAttributeArray = this.getAttributes();
                n = this.getOffset() + this.getName().length();
                for (int i = 0; i < fuzzyXMLAttributeArray.length; ++i) {
                    n += fuzzyXMLAttributeArray[i].toXMLString().length();
                }
                abstractFuzzyXMLNode.setOffset(n += 2);
                abstractFuzzyXMLNode.setLength(fuzzyXMLNode.toXMLString().length());
                this.children.add(fuzzyXMLNode);
                String string = this.toXMLString();
                this.children.remove(fuzzyXMLNode);
                this.fireModifyEvent(string, this.getOffset(), this.getLength());
                this.appendOffset(this, n, string.length() - n2);
                this.children.add(fuzzyXMLNode);
            } else {
                for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
                    n = fuzzyXMLNodeArray[i].getOffset() + fuzzyXMLNodeArray[i].getLength();
                }
                this.fireModifyEvent(abstractFuzzyXMLNode.toXMLString(), n, 0);
                this.appendOffset(this, n, fuzzyXMLNode.toXMLString().length());
                abstractFuzzyXMLNode.setOffset(n);
                abstractFuzzyXMLNode.setLength(fuzzyXMLNode.toXMLString().length());
                this.children.add(fuzzyXMLNode);
            }
        }
    }

    public FuzzyXMLAttribute[] getAttributes() {
        return this.attributes.toArray(new FuzzyXMLAttribute[this.attributes.size()]);
    }

    public FuzzyXMLNode[] getChildren() {
        return this.children.toArray(new FuzzyXMLNode[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public void insertBefore(FuzzyXMLNode fuzzyXMLNode, FuzzyXMLNode fuzzyXMLNode2) {
        int n;
        if (fuzzyXMLNode instanceof FuzzyXMLAttribute || fuzzyXMLNode2 instanceof FuzzyXMLAttribute) {
            return;
        }
        FuzzyXMLNode fuzzyXMLNode3 = null;
        int n2 = -1;
        FuzzyXMLNode[] fuzzyXMLNodeArray = this.getChildren();
        for (n = 0; n < fuzzyXMLNodeArray.length; ++n) {
            if (fuzzyXMLNodeArray[n] != fuzzyXMLNode2) continue;
            fuzzyXMLNode3 = fuzzyXMLNodeArray[n];
            n2 = n;
            break;
        }
        if (fuzzyXMLNode3 == null) {
            return;
        }
        n = fuzzyXMLNode3.getOffset();
        this.fireModifyEvent(fuzzyXMLNode.toXMLString(), n, 0);
        AbstractFuzzyXMLNode abstractFuzzyXMLNode = (AbstractFuzzyXMLNode)fuzzyXMLNode;
        abstractFuzzyXMLNode.setParentNode(this);
        abstractFuzzyXMLNode.setDocument(this.getDocument());
        abstractFuzzyXMLNode.setOffset(n);
        abstractFuzzyXMLNode.setLength(fuzzyXMLNode.toXMLString().length());
        this.appendOffset(this, n, abstractFuzzyXMLNode.toXMLString().length());
        this.children.add(n2, abstractFuzzyXMLNode);
    }

    public void replaceChild(FuzzyXMLNode fuzzyXMLNode, FuzzyXMLNode fuzzyXMLNode2) {
        if (fuzzyXMLNode instanceof FuzzyXMLAttribute || fuzzyXMLNode2 instanceof FuzzyXMLAttribute) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.children.size(); ++i) {
            if (fuzzyXMLNode2 != this.children.get(i)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        this.children.remove(n);
        AbstractFuzzyXMLNode abstractFuzzyXMLNode = (AbstractFuzzyXMLNode)fuzzyXMLNode;
        abstractFuzzyXMLNode.setParentNode(this);
        abstractFuzzyXMLNode.setDocument(this.getDocument());
        abstractFuzzyXMLNode.setOffset(fuzzyXMLNode2.getOffset());
        abstractFuzzyXMLNode.setLength(fuzzyXMLNode.toXMLString().length());
        this.fireModifyEvent(fuzzyXMLNode.toXMLString(), fuzzyXMLNode2.getOffset(), fuzzyXMLNode2.getLength());
        this.appendOffset(this, fuzzyXMLNode2.getOffset(), fuzzyXMLNode.getLength() - fuzzyXMLNode2.getLength());
        this.children.add(n, fuzzyXMLNode);
    }

    public void removeChild(FuzzyXMLNode fuzzyXMLNode) {
        if (fuzzyXMLNode instanceof FuzzyXMLAttribute) {
            this.removeAttributeNode((FuzzyXMLAttribute)fuzzyXMLNode);
            return;
        }
        if (this.children.contains(fuzzyXMLNode)) {
            this.children.remove(fuzzyXMLNode);
            this.fireModifyEvent("", fuzzyXMLNode.getOffset(), fuzzyXMLNode.getLength());
            this.appendOffset(this, fuzzyXMLNode.getOffset(), fuzzyXMLNode.getLength() * -1);
        }
    }

    public void setAttribute(FuzzyXMLAttribute fuzzyXMLAttribute) {
        FuzzyXMLAttribute fuzzyXMLAttribute2 = this.getAttributeNode(fuzzyXMLAttribute.getName());
        if (fuzzyXMLAttribute2 == null) {
            if (this.attributes.contains(fuzzyXMLAttribute)) {
                return;
            }
            if (this.getDocument() == null) {
                this.attributes.add(fuzzyXMLAttribute);
                return;
            }
            FuzzyXMLAttributeImpl fuzzyXMLAttributeImpl = (FuzzyXMLAttributeImpl)fuzzyXMLAttribute;
            fuzzyXMLAttributeImpl.setDocument(this.getDocument());
            fuzzyXMLAttributeImpl.setParentNode(this);
            FuzzyXMLAttribute[] fuzzyXMLAttributeArray = this.getAttributes();
            int n = this.getOffset() + this.getName().length() + 1;
            for (int i = 0; i < fuzzyXMLAttributeArray.length; ++i) {
                n += fuzzyXMLAttributeArray[i].toXMLString().length();
            }
            this.fireModifyEvent(fuzzyXMLAttribute.toXMLString(), n, 0);
            this.appendOffset(this, n, fuzzyXMLAttribute.toXMLString().length());
            fuzzyXMLAttributeImpl.setOffset(n);
            fuzzyXMLAttributeImpl.setLength(fuzzyXMLAttributeImpl.toXMLString().length());
            this.attributes.add(fuzzyXMLAttributeImpl);
        } else {
            FuzzyXMLAttributeImpl fuzzyXMLAttributeImpl = (FuzzyXMLAttributeImpl)fuzzyXMLAttribute2;
            fuzzyXMLAttributeImpl.setValue(fuzzyXMLAttribute.getValue());
        }
    }

    public FuzzyXMLAttribute getAttributeNode(String string) {
        FuzzyXMLAttribute[] fuzzyXMLAttributeArray = this.getAttributes();
        for (int i = 0; i < fuzzyXMLAttributeArray.length; ++i) {
            if (!fuzzyXMLAttributeArray[i].getName().equals(string)) continue;
            return fuzzyXMLAttributeArray[i];
        }
        return null;
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public void removeAttributeNode(FuzzyXMLAttribute fuzzyXMLAttribute) {
        if (this.attributes.contains(fuzzyXMLAttribute)) {
            this.attributes.remove(fuzzyXMLAttribute);
            this.fireModifyEvent("", fuzzyXMLAttribute.getOffset(), fuzzyXMLAttribute.getLength());
            this.appendOffset(this, fuzzyXMLAttribute.getOffset(), fuzzyXMLAttribute.toXMLString().length() * -1);
        }
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        FuzzyXMLNode[] fuzzyXMLNodeArray = this.getChildren();
        for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
            if (!(fuzzyXMLNodeArray[i] instanceof FuzzyXMLText)) continue;
            stringBuffer.append(((FuzzyXMLText)fuzzyXMLNodeArray[i]).getValue());
        }
        return stringBuffer.toString();
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(FuzzyXMLUtil.escape(this.getName()));
        FuzzyXMLAttribute[] fuzzyXMLAttributeArray = this.getAttributes();
        for (int i = 0; i < fuzzyXMLAttributeArray.length; ++i) {
            stringBuffer.append(fuzzyXMLAttributeArray[i].toXMLString());
        }
        FuzzyXMLNode[] fuzzyXMLNodeArray = this.getChildren();
        if (fuzzyXMLNodeArray.length == 0) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
                stringBuffer.append(fuzzyXMLNodeArray[i].toXMLString());
            }
            stringBuffer.append("</").append(FuzzyXMLUtil.escape(this.getName())).append(">");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof FuzzyXMLElement) {
            FuzzyXMLElement fuzzyXMLElement = (FuzzyXMLElement)object;
            if (!fuzzyXMLElement.getName().equals(this.getName())) {
                return false;
            }
            FuzzyXMLNode fuzzyXMLNode = fuzzyXMLElement.getParentNode();
            if (fuzzyXMLNode == null) {
                return this.getParentNode() == null;
            }
            if (fuzzyXMLElement.getOffset() == this.getOffset()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "element: " + this.getName();
    }
}

