/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FuzzyXMLUtil {
    private static Pattern encoding = Pattern.compile("<\\?xml\\s+[^\\?>]*?encoding\\s*=\\s*\"(.*?)\"[^\\?>]*?\\?>");
    private static Pattern script = Pattern.compile("(<script.*?>)(.*?)(</script>)", 34);

    public static String escapeScript(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Matcher matcher = script.matcher(string);
        while (matcher.find()) {
            if (matcher.start() != 0) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            stringBuffer.append(matcher.group(1));
            String string2 = matcher.group(2);
            for (int i = 0; i < string2.length(); ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(matcher.group(3));
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (n == 0 && c == '\"') {
                    n = 1;
                } else if (n == 1 && c == '\"') {
                    n = 0;
                } else if (n == 0 && c == '\'') {
                    n = 2;
                } else if (n == 2 && c == '\'') {
                    n = 0;
                } else {
                    if (!(n != 1 && n != 2 || c != '<' && c != '>')) {
                        stringBuffer.append(' ');
                        continue;
                    }
                    if (n == 0 && c == '>') {
                        bl = false;
                    }
                }
            } else if (c == '<') {
                bl = true;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String comment2space(String string, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf("<!--", n3)) != -1 && (n = string.indexOf("-->", n2)) != -1) {
            stringBuffer.append(string.substring(n3, n2));
            int n4 = n - n2 + 3;
            if (bl) {
                stringBuffer.append("<!--");
                n4 -= 7;
            }
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append(" ");
            }
            if (bl) {
                stringBuffer.append("-->");
            }
            n3 = n + 3;
        }
        if (n3 != string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public static String cdata2space(String string, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf("<![CDATA[", n3)) != -1 && (n = string.indexOf("]]>", n2)) != -1) {
            stringBuffer.append(string.substring(n3, n2));
            int n4 = n - n2 + 3;
            if (bl) {
                stringBuffer.append("<![CDATA[");
                n4 -= 12;
            }
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append(" ");
            }
            if (bl) {
                stringBuffer.append("]]>");
            }
            n3 = n + 3;
        }
        if (n3 != string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public static String doctype2space(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf("<!DOCTYPE", n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            if (bl) {
                stringBuffer.append("<!DOCTYPE");
            } else {
                stringBuffer.append("         ");
            }
            boolean bl2 = false;
            n += 9;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '[') {
                    bl2 = true;
                }
                if (bl2 && c == ']') {
                    bl2 = false;
                }
                if (!bl2 && c == '>') {
                    if (bl) {
                        stringBuffer.append('>');
                        break;
                    }
                    stringBuffer.append(' ');
                    break;
                }
                stringBuffer.append(" ");
                ++n;
            }
            n2 = n + 1;
        }
        if (n2 != string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String processing2space(String string, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf("<?", n3)) != -1 && (n = string.indexOf("?>", n2)) != -1) {
            stringBuffer.append(string.substring(n3, n2));
            int n4 = n - n2 + 2;
            if (bl) {
                stringBuffer.append("<?");
                n4 -= 4;
            }
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append(" ");
            }
            if (bl) {
                stringBuffer.append("?>");
            }
            n3 = n + 2;
        }
        if (n3 != string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        inputStream.close();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static String escape(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("'", "&apos;");
        return string;
    }

    public static String decode(String string) {
        string = string.replaceAll("&quot;", "\"");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&apos;", "'");
        string = string.replaceAll("&amp;", "&");
        return string;
    }

    public static String escapeCDATA(String string) {
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public static String getEncoding(byte[] byArray) {
        String string = new String(byArray);
        Matcher matcher = encoding.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static int getSpaceIndex(String string) {
        char[] cArray = new char[]{' ', '\t', '\r', '\n'};
        for (int i = 0; i < cArray.length; ++i) {
            int n = string.indexOf(cArray[i]);
            if (n < 0) continue;
            return n;
        }
        return -1;
    }
}

