package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLText;

public class FuzzyXMLTextImpl extends AbstractFuzzyXMLNode implements FuzzyXMLText {
    
    private String value;
    
    public FuzzyXMLTextImpl(String value) {
        this(null,value,-1,-1);
    }
    
    public FuzzyXMLTextImpl(FuzzyXMLNode parent,String value,int offset,int length) {
        super(parent,offset,length);
        this.value  = value;
    }

    public String getValue() {
        return FuzzyXMLUtil.decode(value);
    }
    
    public String toXMLString(){
        return FuzzyXMLUtil.escape(getValue());
    }
    
    public String toString(){
        return "text: " + getValue();
    }

}
