/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSImportRuleImpl
implements CSSImportRule,
Serializable {
    CSSStyleSheetImpl _parentStyleSheet = null;
    CSSRule _parentRule = null;
    String _href = null;
    MediaList _media = null;

    public CSSImportRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, String string, MediaList mediaList) {
        this._parentStyleSheet = cSSStyleSheetImpl;
        this._parentRule = cSSRule;
        this._href = string;
        this._media = mediaList;
    }

    public short getType() {
        return 3;
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@import url(").append(this.getHref()).append(")");
        if (this.getMedia().getLength() > 0) {
            stringBuffer.append(" ").append(this.getMedia().toString());
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public void setCssText(String string) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 3) {
                throw new DOMExceptionImpl(13, 6);
            }
            this._href = ((CSSImportRuleImpl)cSSRule)._href;
            this._media = ((CSSImportRuleImpl)cSSRule)._media;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getHref() {
        return this._href;
    }

    public MediaList getMedia() {
        return this._media;
    }

    public CSSStyleSheet getStyleSheet() {
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

