/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCDATAImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCommentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocTypeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocumentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLElementImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLProcessingInstructionImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLTextImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.resources.Messages;

public class FuzzyXMLParser {
    private Stack stack = new Stack();
    private String originalSource;
    private FuzzyXMLElementImpl root;
    private FuzzyXMLDocType docType;
    private ArrayList listeners = new ArrayList();
    private ArrayList nonCloseElement = new ArrayList();
    private Pattern tag = Pattern.compile("<((|/)([^<>]*))([^<]|>)");
    private Pattern docTypeName = Pattern.compile("^<!DOCTYPE[ \r\n\t]+([\\w\\-_]*)");
    private Pattern docTypePublic = Pattern.compile("PUBLIC[ \r\n\t]+\"(.*?)\"[ \r\n\t]+\"(.*?)\"");
    private Pattern docTypeSystem = Pattern.compile("SYSTEM[ \r\n\t]+\"(.*?)\"");
    private Pattern docTypeSubset = Pattern.compile("\\[([^\\]]*)\\]>");

    public void addErrorListener(FuzzyXMLErrorListener listener) {
        this.listeners.add(listener);
    }

    private void fireErrorEvent(int offset, int length, String message, FuzzyXMLNode node) {
        FuzzyXMLErrorEvent evt = new FuzzyXMLErrorEvent(offset, length, message, node);
        int i = 0;
        while (i < this.listeners.size()) {
            FuzzyXMLErrorListener listener = (FuzzyXMLErrorListener)this.listeners.get(i);
            listener.error(evt);
            ++i;
        }
    }

    public FuzzyXMLDocument parse(InputStream in) throws IOException {
        byte[] bytes = FuzzyXMLUtil.readStream(in);
        String encode = FuzzyXMLUtil.getEncoding(bytes);
        if (encode == null) {
            return this.parse(new String(bytes));
        }
        return this.parse(new String(bytes, encode));
    }

    public FuzzyXMLDocument parse(File file) throws IOException {
        byte[] bytes = FuzzyXMLUtil.readStream(new FileInputStream(file));
        String encode = FuzzyXMLUtil.getEncoding(bytes);
        if (encode == null) {
            return this.parse(new String(bytes));
        }
        return this.parse(new String(bytes, encode));
    }

    public FuzzyXMLDocument parse(String source) {
        this.originalSource = source;
        source = FuzzyXMLUtil.comment2space(source, true);
        source = FuzzyXMLUtil.escapeScript(source);
        source = FuzzyXMLUtil.scriptlet2space(source, true);
        source = FuzzyXMLUtil.cdata2space(source, true);
        source = FuzzyXMLUtil.doctype2space(source, true);
        source = FuzzyXMLUtil.processing2space(source, true);
        source = FuzzyXMLUtil.escapeString(source);
        Matcher matcher = this.tag.matcher(source);
        int lastIndex = -1;
        while (matcher.find()) {
            String text;
            if (lastIndex != -1 && lastIndex < matcher.start()) {
                this.handleText(lastIndex, matcher.start());
            }
            if ((text = matcher.group(1).trim()).startsWith("%")) {
                this.handleText(matcher.start(), matcher.end());
            } else if (text.startsWith("?")) {
                this.handleDeclaration(matcher.start(), matcher.end());
            } else if (text.startsWith("!DOCTYPE") || text.startsWith("!doctype")) {
                this.handleDoctype(matcher.start(), matcher.end(), text);
            } else if (text.startsWith("![CDATA[")) {
                this.handleCDATA(matcher.start(), matcher.end(), this.originalSource.substring(matcher.start(), matcher.end()));
            } else if (text.startsWith("/")) {
                this.handleCloseTag(matcher.start(), matcher.end(), text);
            } else if (text.startsWith("!--")) {
                this.handleComment(matcher.start(), matcher.end(), this.originalSource.substring(matcher.start(), matcher.end()));
            } else if (text.endsWith("/")) {
                this.handleEmptyTag(matcher.start(), matcher.end());
            } else {
                this.handleStartTag(matcher.start(), matcher.end());
            }
            lastIndex = matcher.end();
        }
        FuzzyXMLElementImpl docElement = null;
        if (this.root == null) {
            docElement = new FuzzyXMLElementImpl(null, "document", 0, this.originalSource.length());
        } else {
            docElement = new FuzzyXMLElementImpl(null, "document", this.root.getOffset(), this.root.getLength());
            docElement.appendChildWithNoCheck(this.root);
        }
        return new FuzzyXMLDocumentImpl(docElement, this.docType);
    }

    private void handleCDATA(int offset, int end, String text) {
        if (this.getParent() != null) {
            text = text.replaceFirst("<!\\[CDATA\\[", "");
            text = text.replaceFirst("\\]\\]>", "");
            FuzzyXMLCDATAImpl cdata = new FuzzyXMLCDATAImpl(this.getParent(), text, offset, end - offset);
            ((FuzzyXMLElement)this.getParent()).appendChild(cdata);
        }
    }

    private void handleText(int offset, int end) {
        String text = this.originalSource.substring(offset, end);
        if (this.getParent() != null) {
            FuzzyXMLTextImpl textNode = new FuzzyXMLTextImpl(this.getParent(), FuzzyXMLUtil.decode(text), offset, end - offset);
            textNode.setEscape(false);
            ((FuzzyXMLElement)this.getParent()).appendChild(textNode);
        }
    }

    private void handleDeclaration(int offset, int end) {
        if (this.getParent() != null) {
            String text = this.originalSource.substring(offset, end);
            text = text.replaceFirst("^<\\?", "");
            text = text.replaceFirst("\\?>$", "");
            text = text.trim();
            String[] dim = text.split("[ \r\n\t]+");
            String name = dim[0];
            String data = text.substring(name.length()).trim();
            FuzzyXMLProcessingInstructionImpl pi = new FuzzyXMLProcessingInstructionImpl(null, name, data, offset, end - offset);
            ((FuzzyXMLElement)this.getParent()).appendChild(pi);
        }
    }

    private void handleDoctype(int offset, int end, String text) {
        if (this.docType == null) {
            String name = "";
            String publicId = "";
            String systemId = "";
            String internalSubset = "";
            text = this.originalSource.substring(offset, end);
            Matcher matcher = this.docTypeName.matcher(text);
            if (matcher.find()) {
                name = matcher.group(1);
            }
            if ((matcher = this.docTypePublic.matcher(text)).find()) {
                publicId = matcher.group(1);
                systemId = matcher.group(2);
            } else {
                matcher = this.docTypeSystem.matcher(text);
                if (matcher.find()) {
                    systemId = matcher.group(1);
                }
            }
            matcher = this.docTypeSubset.matcher(text);
            if (matcher.find()) {
                internalSubset = matcher.group(1);
            }
            this.docType = new FuzzyXMLDocTypeImpl(null, name, publicId, systemId, internalSubset, offset, end - offset);
        }
    }

    private void handleCloseTag(int offset, int end, String text) {
        if (this.stack.size() == 0) {
            return;
        }
        String tagName = text.substring(1).trim();
        FuzzyXMLElementImpl element = (FuzzyXMLElementImpl)this.stack.pop();
        if (!element.getName().toLowerCase().equals(tagName.toLowerCase())) {
            if (element.getParentNode() != null) {
                ((FuzzyXMLElementImpl)element.getParentNode()).appendChildWithNoCheck(element);
                FuzzyXMLNode[] nodes = element.getChildren();
                int i = 0;
                while (i < nodes.length) {
                    ((AbstractFuzzyXMLNode)nodes[i]).setParentNode(element.getParentNode());
                    element.removeChild(nodes[i]);
                    ((FuzzyXMLElementImpl)element.getParentNode()).appendChildWithNoCheck(nodes[i]);
                    ++i;
                }
            } else {
                this.fireErrorEvent(offset, end - offset, Messages.getMessage("error.noStartTag", tagName), null);
            }
            this.handleCloseTag(offset, end, text);
            return;
        }
        element.setLength(end - element.getOffset());
        this.nonCloseElement.remove(element);
        if (element.getParentNode() == null) {
            this.root = element;
            int i = 0;
            while (i < this.nonCloseElement.size()) {
                FuzzyXMLElement error = (FuzzyXMLElement)this.nonCloseElement.get(i);
                this.fireErrorEvent(error.getOffset(), error.getLength(), Messages.getMessage("error.noCloseTag", error.getName()), error);
                ++i;
            }
        } else {
            ((FuzzyXMLElementImpl)element.getParentNode()).appendChildWithNoCheck(element);
        }
    }

    private void handleEmptyTag(int offset, int end) {
        TagInfo info = this.parseTagContents(this.originalSource.substring(offset + 1, end - 1));
        FuzzyXMLNode parent = this.getParent();
        FuzzyXMLElementImpl element = new FuzzyXMLElementImpl(parent, info.name, offset, end - offset);
        if (parent == null) {
            this.root = element;
        } else {
            ((FuzzyXMLElement)parent).appendChild(element);
        }
        AttrInfo[] attrs = info.getAttrs();
        int i = 0;
        while (i < attrs.length) {
            FuzzyXMLAttributeImpl attr = new FuzzyXMLAttributeImpl(element, attrs[i].name, attrs[i].value, attrs[i].offset + offset, attrs[i].end - attrs[i].offset + 1);
            element.appendChild(attr);
            ++i;
        }
    }

    private void handleComment(int offset, int end, String text) {
        if (this.getParent() != null) {
            text = text.replaceFirst("<!--", "");
            text = text.replaceFirst("-->", "");
            FuzzyXMLCommentImpl comment = new FuzzyXMLCommentImpl(this.getParent(), text, offset, end - offset);
            ((FuzzyXMLElement)this.getParent()).appendChild(comment);
        }
    }

    private void handleStartTag(int offset, int end) {
        TagInfo info = this.parseTagContents(this.originalSource.substring(offset + 1, end - 1));
        FuzzyXMLElementImpl element = new FuzzyXMLElementImpl(this.getParent(), info.name, offset, end - offset);
        AttrInfo[] attrs = info.getAttrs();
        int i = 0;
        while (i < attrs.length) {
            FuzzyXMLAttributeImpl attr = new FuzzyXMLAttributeImpl(element, attrs[i].name, attrs[i].value, attrs[i].offset + offset, attrs[i].end - attrs[i].offset + 1);
            attr.setQuoteCharacter(attrs[i].quote);
            if (attrs[i].value.indexOf(34) >= 0 || attrs[i].value.indexOf(39) >= 0 || attrs[i].value.indexOf(60) >= 0 || attrs[i].value.indexOf(62) >= 0 || attrs[i].value.indexOf(38) >= 0) {
                attr.setEscape(false);
            }
            element.appendChild(attr);
            ++i;
        }
        this.stack.push(element);
        this.nonCloseElement.add(element);
    }

    private FuzzyXMLNode getParent() {
        if (this.stack.size() == 0) {
            return null;
        }
        return (FuzzyXMLNode)this.stack.get(this.stack.size() - 1);
    }

    private TagInfo parseTagContents(String text) {
        if ((text = text.trim()).endsWith("/")) {
            text = text.substring(0, text.length() - 1);
        }
        TagInfo info = new TagInfo();
        if (FuzzyXMLUtil.getSpaceIndex(text) != -1) {
            info.name = text.substring(0, FuzzyXMLUtil.getSpaceIndex(text)).trim();
            this.parseAttributeContents(info, text);
        } else {
            info.name = text;
        }
        return info;
    }

    private void parseAttributeContents(TagInfo info, String text) {
        int flag = 0;
        StringBuffer sb = new StringBuffer();
        String name = null;
        char quote = '\u0000';
        int start = -1;
        boolean escape = false;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (flag == 0 && FuzzyXMLUtil.isWhitespace(c)) {
                flag = 1;
            } else if (flag == 1 && !FuzzyXMLUtil.isWhitespace(c)) {
                if (start == -1) {
                    start = i;
                }
                flag = 2;
                sb.append(c);
            } else if (flag == 2) {
                if (c == '=') {
                    flag = 3;
                    name = sb.toString().trim();
                    sb.setLength(0);
                } else {
                    sb.append(c);
                }
            } else if (flag == 3 && !FuzzyXMLUtil.isWhitespace(c)) {
                quote = c;
                flag = 4;
            } else if (flag == 4) {
                if (c == quote && escape) {
                    sb.append(c);
                    escape = false;
                } else if (c == quote) {
                    AttrInfo attr = new AttrInfo();
                    attr.name = name;
                    attr.value = FuzzyXMLUtil.decode(sb.toString());
                    attr.offset = start;
                    attr.end = i + 1;
                    attr.quote = quote;
                    info.addAttr(attr);
                    sb.setLength(0);
                    flag = 1;
                    start = -1;
                } else if (c == '\\') {
                    if (escape) {
                        sb.append(c);
                    } else {
                        escape = true;
                    }
                } else {
                    sb.append(c);
                    escape = false;
                }
            }
            ++i;
        }
    }

    private class TagInfo {
        private String name;
        private ArrayList attrs = new ArrayList();

        TagInfo() {
        }

        public void addAttr(AttrInfo attr) {
            AttrInfo[] info = this.getAttrs();
            int i = 0;
            while (i < info.length) {
                if (info[i].name.equals(attr.name)) {
                    return;
                }
                ++i;
            }
            this.attrs.add(attr);
        }

        public AttrInfo[] getAttrs() {
            return this.attrs.toArray(new AttrInfo[this.attrs.size()]);
        }
    }

    private class AttrInfo {
        private String name;
        private String value;
        private int offset;
        private int end;
        private char quote;

        AttrInfo() {
        }
    }
}

