/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;

public class FuzzyXMLAttributeImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLAttribute {
    private char quote = (char)34;
    private boolean escape = true;
    private String name;
    private String value;

    public FuzzyXMLAttributeImpl(String name) {
        this(null, name, null, -1, -1);
    }

    public FuzzyXMLAttributeImpl(FuzzyXMLNode parent, String name, String value, int offset, int length) {
        super(parent, offset, length);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        if (this.value == null) {
            this.value = "";
        }
        int length = this.value.length();
        this.value = value;
        this.fireModifyEvent(this.toXMLString(), this.getOffset(), this.getLength());
        this.appendOffset((FuzzyXMLElement)this.getParentNode(), this.getOffset(), value.length() - length);
    }

    public String getValue() {
        return this.value;
    }

    public char getQuoteCharacter() {
        return this.quote;
    }

    public void setQuoteCharacter(char c) {
        this.quote = c;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(FuzzyXMLUtil.escape(this.getName()));
        sb.append("=");
        sb.append(this.quote);
        if (this.escape) {
            sb.append(FuzzyXMLUtil.escape(this.getValue()));
        } else {
            sb.append(this.getValue());
        }
        sb.append(this.quote);
        return sb.toString();
    }

    public String toString() {
        return "attr: " + this.getName() + "=" + this.getValue();
    }
}

