/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLException;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocumentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;

public class FuzzyXMLElementImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLElement {
    private ArrayList children = new ArrayList();
    private ArrayList attributes = new ArrayList();
    private String name;

    public FuzzyXMLElementImpl(String name) {
        this(null, name, -1, -1);
    }

    public FuzzyXMLElementImpl(FuzzyXMLNode parent, String name, int offset, int length) {
        super(parent, offset, length);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void appendChildrenFromText(String text) {
        if (text.length() == 0) {
            return;
        }
        FuzzyXMLElementImpl test = new FuzzyXMLElementImpl("test");
        this.appendChild(test);
        int offset = test.getOffset();
        this.removeChild(test);
        String parseText = "<root>" + text + "</root>";
        FuzzyXMLElement root = new FuzzyXMLParser().parse(parseText).getDocumentElement();
        ((AbstractFuzzyXMLNode)((Object)root)).appendOffset(root, 0, -6);
        ((AbstractFuzzyXMLNode)((Object)root)).appendOffset(root, 0, offset);
        FuzzyXMLNode[] nodes = ((FuzzyXMLElement)root.getChildren()[0]).getChildren();
        this.appendOffset(this, offset, text.length());
        int i = 0;
        while (i < nodes.length) {
            this.appendChild(nodes[i], false, false);
            ++i;
        }
        this.fireModifyEvent(text, offset, 0);
    }

    public void appendChild(FuzzyXMLNode node) {
        this.appendChild(node, true, true);
    }

    public void appendChildWithNoCheck(FuzzyXMLNode node) {
        this.appendChild(node, true, false);
    }

    private void appendChild(FuzzyXMLNode node, boolean fireEvent, boolean check) {
        if (check) {
            if (((AbstractFuzzyXMLNode)node).getDocument() != null) {
                throw new FuzzyXMLException("Appended node already has a parent.");
            }
            if (node instanceof FuzzyXMLElement && ((FuzzyXMLElement)node).getChildren().length != 0) {
                throw new FuzzyXMLException("Appended node has chidlren.");
            }
        }
        AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)node;
        nodeImpl.setParentNode(this);
        nodeImpl.setDocument(this.getDocument());
        if (node instanceof FuzzyXMLAttribute) {
            this.setAttribute((FuzzyXMLAttribute)node);
        } else {
            if (this.children.contains(node)) {
                return;
            }
            if (this.getDocument() == null) {
                this.children.add(node);
                return;
            }
            FuzzyXMLNode[] nodes = this.getChildren();
            int offset = 0;
            if (nodes.length == 0) {
                int length = this.getLength();
                FuzzyXMLAttribute[] attrs = this.getAttributes();
                offset = this.getOffset() + this.getName().length();
                int i = 0;
                while (i < attrs.length) {
                    offset += attrs[i].toXMLString().length();
                    ++i;
                }
                nodeImpl.setOffset(offset += 2);
                if (fireEvent) {
                    nodeImpl.setLength(node.toXMLString().length());
                }
                this.children.add(node);
                String xml = this.toXMLString();
                this.children.remove(node);
                if (fireEvent) {
                    this.fireModifyEvent(xml, this.getOffset(), this.getLength());
                    this.appendOffset(this, offset, xml.length() - length);
                }
                this.children.add(node);
            } else {
                int i = 0;
                while (i < nodes.length) {
                    offset = nodes[i].getOffset() + nodes[i].getLength();
                    ++i;
                }
                if (fireEvent) {
                    this.fireModifyEvent(nodeImpl.toXMLString(), offset, 0);
                    this.appendOffset(this, offset, node.toXMLString().length());
                }
                nodeImpl.setOffset(offset);
                if (fireEvent) {
                    nodeImpl.setLength(node.toXMLString().length());
                }
                this.children.add(node);
            }
        }
    }

    public FuzzyXMLAttribute[] getAttributes() {
        return this.attributes.toArray(new FuzzyXMLAttribute[this.attributes.size()]);
    }

    public FuzzyXMLNode[] getChildren() {
        return this.children.toArray(new FuzzyXMLNode[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public void insertBefore(FuzzyXMLNode newChild, FuzzyXMLNode refChild) {
        if (newChild instanceof FuzzyXMLAttribute || refChild instanceof FuzzyXMLAttribute) {
            return;
        }
        FuzzyXMLNode target = null;
        int index = -1;
        FuzzyXMLNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] == refChild) {
                target = children[i];
                index = i;
                break;
            }
            ++i;
        }
        if (target == null) {
            return;
        }
        int offset = target.getOffset();
        this.fireModifyEvent(newChild.toXMLString(), offset, 0);
        AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)newChild;
        nodeImpl.setParentNode(this);
        nodeImpl.setDocument(this.getDocument());
        nodeImpl.setOffset(offset);
        nodeImpl.setLength(newChild.toXMLString().length());
        this.appendOffset(this, offset, nodeImpl.toXMLString().length());
        this.children.add(index, nodeImpl);
    }

    public void replaceChild(FuzzyXMLNode newChild, FuzzyXMLNode refChild) {
        if (newChild instanceof FuzzyXMLAttribute || refChild instanceof FuzzyXMLAttribute) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.children.size()) {
            if (refChild == this.children.get(i)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        this.children.remove(index);
        AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)newChild;
        nodeImpl.setParentNode(this);
        nodeImpl.setDocument(this.getDocument());
        nodeImpl.setOffset(refChild.getOffset());
        nodeImpl.setLength(newChild.toXMLString().length());
        this.fireModifyEvent(newChild.toXMLString(), refChild.getOffset(), refChild.getLength());
        this.appendOffset(this, refChild.getOffset(), newChild.getLength() - refChild.getLength());
        this.children.add(index, newChild);
    }

    public void removeChild(FuzzyXMLNode oldChild) {
        if (oldChild instanceof FuzzyXMLAttribute) {
            this.removeAttributeNode((FuzzyXMLAttribute)oldChild);
            return;
        }
        if (this.children.contains(oldChild)) {
            ((AbstractFuzzyXMLNode)oldChild).setParentNode(null);
            ((AbstractFuzzyXMLNode)oldChild).setDocument(null);
            this.children.remove(oldChild);
            this.fireModifyEvent("", oldChild.getOffset(), oldChild.getLength());
            this.appendOffset(this, oldChild.getOffset(), oldChild.getLength() * -1);
        }
    }

    public void setAttribute(FuzzyXMLAttribute attr) {
        FuzzyXMLAttribute attrNode = this.getAttributeNode(attr.getName());
        if (attrNode == null) {
            if (this.attributes.contains(attr)) {
                return;
            }
            if (this.getDocument() == null) {
                this.attributes.add(attr);
                return;
            }
            FuzzyXMLAttributeImpl attrImpl = (FuzzyXMLAttributeImpl)attr;
            attrImpl.setDocument(this.getDocument());
            attrImpl.setParentNode(this);
            FuzzyXMLAttribute[] attrs = this.getAttributes();
            int offset = this.getOffset() + this.getName().length() + 1;
            int i = 0;
            while (i < attrs.length) {
                offset += attrs[i].toXMLString().length();
                ++i;
            }
            this.fireModifyEvent(attr.toXMLString(), offset, 0);
            this.appendOffset(this, offset, attr.toXMLString().length());
            attrImpl.setOffset(offset);
            attrImpl.setLength(attrImpl.toXMLString().length());
            this.attributes.add(attrImpl);
        } else {
            FuzzyXMLAttributeImpl attrImpl = (FuzzyXMLAttributeImpl)attrNode;
            attrImpl.setValue(attr.getValue());
        }
    }

    public FuzzyXMLAttribute getAttributeNode(String name) {
        FuzzyXMLAttribute[] attrs = this.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].getName().equals(name)) {
                return attrs[i];
            }
            ++i;
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public void removeAttributeNode(FuzzyXMLAttribute attr) {
        if (this.attributes.contains(attr)) {
            ((AbstractFuzzyXMLNode)((Object)attr)).setParentNode(null);
            ((AbstractFuzzyXMLNode)((Object)attr)).setDocument(null);
            this.attributes.remove(attr);
            this.fireModifyEvent("", attr.getOffset(), attr.getLength());
            this.appendOffset(this, attr.getOffset(), attr.getLength() * -1);
        }
    }

    public String getValue() {
        StringBuffer sb = new StringBuffer();
        FuzzyXMLNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLText) {
                sb.append(((FuzzyXMLText)children[i]).getValue());
            }
            ++i;
        }
        return sb.toString();
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(FuzzyXMLUtil.escape(this.getName()));
        FuzzyXMLAttribute[] attrs = this.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            sb.append(attrs[i].toXMLString());
            ++i;
        }
        FuzzyXMLNode[] children = this.getChildren();
        if (children.length == 0) {
            sb.append("/>");
        } else {
            sb.append(">");
            int i2 = 0;
            while (i2 < children.length) {
                sb.append(children[i2].toXMLString());
                ++i2;
            }
            sb.append("</").append(FuzzyXMLUtil.escape(this.getName())).append(">");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FuzzyXMLElement) {
            FuzzyXMLElement element = (FuzzyXMLElement)obj;
            if (!element.getName().equals(this.getName())) {
                return false;
            }
            FuzzyXMLNode parent = element.getParentNode();
            if (parent == null) {
                return this.getParentNode() == null;
            }
            if (element.getOffset() == this.getOffset()) {
                return true;
            }
        }
        return false;
    }

    public void setDocument(FuzzyXMLDocumentImpl doc) {
        super.setDocument(doc);
        FuzzyXMLNode[] nodes = this.getChildren();
        int i = 0;
        while (i < nodes.length) {
            ((AbstractFuzzyXMLNode)nodes[i]).setDocument(doc);
            ++i;
        }
        FuzzyXMLAttribute[] attrs = this.getAttributes();
        int i2 = 0;
        while (i2 < attrs.length) {
            ((AbstractFuzzyXMLNode)((Object)attrs[i2])).setDocument(doc);
            ++i2;
        }
    }

    public String toString() {
        return "element: " + this.getName();
    }

    public void removeAllChildren() {
        FuzzyXMLNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            this.removeChild(children[i]);
            ++i;
        }
    }
}

