/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FuzzyXMLUtil {
    private static Pattern encoding = Pattern.compile("<\\?xml\\s+[^\\?>]*?encoding\\s*=\\s*\"(.*?)\"[^\\?>]*?\\?>");
    private static Pattern script = Pattern.compile("(<script.*?>)(.*?)(</script>)", 34);

    public static String escapeScript(String source) {
        StringBuffer sb = new StringBuffer();
        int lastIndex = 0;
        Matcher matcher = script.matcher(source);
        while (matcher.find()) {
            if (matcher.start() != 0) {
                sb.append(source.substring(lastIndex, matcher.start()));
            }
            sb.append(matcher.group(1));
            String group2 = matcher.group(2);
            int i = 0;
            while (i < group2.length()) {
                sb.append(" ");
                ++i;
            }
            sb.append(matcher.group(3));
            lastIndex = matcher.end();
        }
        if (lastIndex < source.length()) {
            sb.append(source.substring(lastIndex));
        }
        return sb.toString();
    }

    public static String escapeString(String source) {
        StringBuffer sb = new StringBuffer();
        int flag = 0;
        boolean tag = false;
        boolean escape = false;
        int i = 0;
        while (i < source.length()) {
            block13: {
                char c;
                block7: {
                    block5: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block6: {
                                                c = source.charAt(i);
                                                if (!tag) break block5;
                                                if (flag != 1 && flag != 2 || c != '\\') break block6;
                                                escape = true;
                                                break block7;
                                            }
                                            if (flag != 0 || c != '\"') break block8;
                                            flag = 1;
                                            break block7;
                                        }
                                        if (flag != 1 || c != '\"') break block9;
                                        if (!escape) {
                                            flag = 0;
                                        }
                                        escape = false;
                                        break block7;
                                    }
                                    if (flag != 0 || c != '\'') break block10;
                                    flag = 2;
                                    break block7;
                                }
                                if (flag != 2 || c != '\'') break block11;
                                if (!escape) {
                                    flag = 0;
                                }
                                escape = false;
                                break block7;
                            }
                            if (flag != 1 && flag != 2) break block12;
                            sb.append(' ');
                            break block13;
                        }
                        if (flag == 0 && c == '>') {
                            tag = false;
                        }
                        break block7;
                    }
                    if (c == '<') {
                        tag = true;
                    }
                }
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String comment2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<!--", last)) != -1) {
            int end = source.indexOf("-->", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 3;
            if (contentsOnly) {
                sb.append("<!--");
                length -= 7;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("-->");
            }
            last = end + 3;
        }
        if (last != source.length()) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static String cdata2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<![CDATA[", last)) != -1) {
            int end = source.indexOf("]]>", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 3;
            if (contentsOnly) {
                sb.append("<![CDATA[");
                length -= 12;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("]]>");
            }
            last = end + 3;
        }
        if (last != source.length()) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static String doctype2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<!DOCTYPE", last)) != -1) {
            sb.append(source.substring(last, index));
            if (contentsOnly) {
                sb.append("<!DOCTYPE");
            } else {
                sb.append("         ");
            }
            boolean flag = false;
            index += 9;
            while (index < source.length()) {
                char c = source.charAt(index);
                if (c == '[') {
                    flag = true;
                }
                if (flag && c == ']') {
                    flag = false;
                }
                if (!flag && c == '>') {
                    if (contentsOnly) {
                        sb.append('>');
                        break;
                    }
                    sb.append(' ');
                    break;
                }
                sb.append(" ");
                ++index;
            }
            last = index + 1;
        }
        if (last != source.length()) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static String processing2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<?", last)) != -1) {
            int end = source.indexOf("?>", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 2;
            if (contentsOnly) {
                sb.append("<?");
                length -= 4;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("?>");
            }
            last = end + 2;
        }
        if (last != source.length()) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static String scriptlet2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<%", last)) != -1) {
            int end = source.indexOf("%>", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 2;
            if (contentsOnly) {
                sb.append("<%");
                length -= 4;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("%>");
            }
            last = end + 2;
        }
        if (last != source.length()) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        byte[] result = out.toByteArray();
        in.close();
        out.close();
        return result;
    }

    public static String escape(String value) {
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("'", "&apos;");
        return value;
    }

    public static String decode(String value) {
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&amp;", "&");
        return value;
    }

    public static String escapeCDATA(String value) {
        value = value.replaceAll(">", "&gt;");
        return value;
    }

    public static String getEncoding(byte[] bytes) {
        String str = new String(bytes);
        Matcher matcher = encoding.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static int getSpaceIndex(String value) {
        char[] chars = new char[]{' ', '\t', '\r', '\n'};
        int i = 0;
        while (i < chars.length) {
            int index = value.indexOf(chars[i]);
            if (index >= 0) {
                return index;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }
}

