/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.sample;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLProcessingInstruction;
import jp.aonir.fuzzyxml.XPath;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.sample.ConsoleAttrDialog;
import jp.aonir.fuzzyxml.sample.ConsoleNodeDialog;
import jp.aonir.fuzzyxml.sample.ConsolePIDialog;

public class Console
extends JFrame {
    private CustomTextArea text = new CustomTextArea();
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
    private DefaultTreeModel model = new DefaultTreeModel(this.root);
    private JTree tree = new JTree(this.model);
    private JPopupMenu popup;
    private FuzzyXMLDocument doc;
    private JFileChooser chooser = new JFileChooser();
    private JList errors = new JList(new DefaultListModel());
    private Action addNodeAction = new AddNodeAction();
    private Action insertBeforeAction = new InsertBeforeAction();
    private Action replaceNodeAction = new ReplaceNodeAction();
    private Action addAttrAction = new AddAttrAction();
    private Action editAttrAction = new EditAttrAction();
    private Action editPIAction = new EditPIAction();
    private Action removeAction = new RemoveAction();
    private Action outputXMLAction = new OutputXMLAction();
    static /* synthetic */ Class class$0;

    public Console() throws Exception {
        super("FuzzyXML Sample");
        this.popup = new JPopupMenu();
        this.popup.add(this.addNodeAction);
        this.popup.add(this.insertBeforeAction);
        this.popup.add(this.replaceNodeAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.addAttrAction);
        this.popup.add(this.editAttrAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.editPIAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.removeAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.outputXMLAction);
        Container cp = this.getContentPane();
        JSplitPane split2 = new JSplitPane(0);
        split2.add(new JScrollPane(this.text));
        split2.add(new JScrollPane(this.errors));
        split2.setDividerLocation(250);
        this.errors.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ErrorInfo info = (ErrorInfo)Console.this.errors.getSelectedValue();
                if (info != null) {
                    Console.this.text.setSelectionStart(info.offset);
                    Console.this.text.setSelectionEnd(info.offset + info.length);
                    Console.this.text.requestFocus();
                }
            }
        });
        JSplitPane split = new JSplitPane(1);
        split.add(new JScrollPane(this.tree));
        split.add(split2);
        split.setDividerLocation(180);
        JToolBar toolbar = new JToolBar();
        JButton button1 = new JButton("Open");
        this.chooser.setFileSelectionMode(0);
        button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (Console.this.chooser.showOpenDialog(Console.this) == 0) {
                    File file = Console.this.chooser.getSelectedFile();
                    try {
                        Console.this.text.setText(Console.this.readFile(file));
                        FuzzyXMLParser parser = new FuzzyXMLParser();
                        parser.addErrorListener(new SampleErrorListener());
                        FuzzyXMLDocument doc = parser.parse(file);
                        Console.this.text.setCaretPosition(0);
                        Console.this.setTree(doc);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        toolbar.add(button1);
        JButton button2 = new JButton("Parse");
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzyXMLParser parser = new FuzzyXMLParser();
                parser.addErrorListener(new SampleErrorListener());
                FuzzyXMLDocument doc = parser.parse(Console.this.text.getText());
                Console.this.setTree(doc);
            }
        });
        toolbar.add(button2);
        toolbar.addSeparator();
        toolbar.add(new JLabel("XPath:"));
        final JTextField xpath = new JTextField();
        toolbar.add(xpath);
        JButton button3 = new JButton("Select");
        button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    FuzzyXMLNode node = XPath.selectSingleNode(Console.this.doc.getDocumentElement(), xpath.getText());
                    Console.this.text.setSelectionStart(node.getOffset());
                    Console.this.text.setSelectionEnd(node.getOffset() + node.getLength());
                    Console.this.text.requestFocus();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Console.this, ex, "Error", 0);
                }
            }
        });
        toolbar.add(button3);
        JButton button4 = new JButton("Value");
        button4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    Object obj = XPath.getValue(Console.this.doc.getDocumentElement(), xpath.getText());
                    JOptionPane.showMessageDialog(Console.this, obj, "XPath", 1);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Console.this, ex, "Error", 0);
                }
            }
        });
        toolbar.add(button4);
        cp.add((Component)toolbar, "North");
        cp.add((Component)split, "Center");
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    try {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                        FuzzyXMLNode obj = (FuzzyXMLNode)node.getUserObject();
                        Console.this.text.fire = false;
                        Console.this.text.setSelectionStart(obj.getOffset());
                        Console.this.text.setSelectionEnd(obj.getOffset() + obj.getLength());
                        Console.this.text.requestFocus();
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    Console.this.text.fire = true;
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                Console.this.text.fire = true;
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Console.this.showPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                Console.this.showPopup(e);
            }

            public void mouseClicked(MouseEvent e) {
                Console.this.showPopup(e);
            }
        });
        this.tree.setSelectionModel(new CustomTreeSelectionModel());
        this.text.setText(this.readFile("sample.xml"));
        this.text.setCaretPosition(0);
        this.text.addCaretListener(new CaretListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void caretUpdate(CaretEvent e) {
                if (Console.this.doc == null) return;
                FuzzyXMLElement element = Console.this.doc.getElementByOffset(Console.this.text.getCaretPosition());
                if (Console.this.getSelectedNode() == element) return;
                TreePath path = Console.this.getPath(element);
                if (path == null) return;
                try {
                    ((CustomTreeSelectionModel)Console.this.tree.getSelectionModel()).fire = false;
                    Console.this.tree.expandPath(path);
                    Console.this.tree.setSelectionPath(path);
                    Console.this.tree.scrollPathToVisible(path);
                    Console.this.tree.repaint();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    ((CustomTreeSelectionModel)Console.this.tree.getSelectionModel()).fire = true;
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                ((CustomTreeSelectionModel)Console.this.tree.getSelectionModel()).fire = true;
            }
        });
        FuzzyXMLParser parser = new FuzzyXMLParser();
        parser.addErrorListener(new SampleErrorListener());
        FuzzyXMLDocument doc = parser.parse(this.text.getText());
        this.setTree(doc);
    }

    private TreePath getPath(FuzzyXMLNode node) {
        if (this.doc == null) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
        list.add(this.root);
        if (this.searchNode(list, this.root, node)) {
            return new TreePath(list.toArray());
        }
        return null;
    }

    private boolean searchNode(ArrayList list, DefaultMutableTreeNode treeNode, FuzzyXMLNode node) {
        int i = 0;
        while (i < treeNode.getChildCount()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            list.add(child);
            if (child.getUserObject() == node) {
                return true;
            }
            if (this.searchNode(list, child, node)) {
                return true;
            }
            list.remove(child);
            ++i;
        }
        return false;
    }

    private void showPopup(MouseEvent e) {
        this.updateActions();
        Component com = (Component)e.getSource();
        if (e.isPopupTrigger()) {
            this.popup.show(com, e.getX(), e.getY());
        }
    }

    private void updateActions() {
        FuzzyXMLNode node = this.getSelectedNode();
        this.addNodeAction.setEnabled(false);
        this.insertBeforeAction.setEnabled(false);
        this.addAttrAction.setEnabled(false);
        this.editAttrAction.setEnabled(false);
        this.editPIAction.setEnabled(false);
        this.removeAction.setEnabled(false);
        this.outputXMLAction.setEnabled(false);
        if (node == null) {
            return;
        }
        this.outputXMLAction.setEnabled(true);
        if (node.getParentNode() != null) {
            this.removeAction.setEnabled(true);
        }
        if (node instanceof FuzzyXMLElement) {
            this.addNodeAction.setEnabled(true);
            this.addAttrAction.setEnabled(true);
        }
        if (node instanceof FuzzyXMLAttribute) {
            this.editAttrAction.setEnabled(true);
        } else if (node.getParentNode() != null) {
            this.insertBeforeAction.setEnabled(true);
        }
        if (node instanceof FuzzyXMLProcessingInstruction) {
            this.editPIAction.setEnabled(true);
        }
    }

    private void reload(DefaultMutableTreeNode node) {
        this.model.reload();
        if (node != null) {
            this.tree.scrollPathToVisible(new TreePath(node.getPath()));
        } else if (this.root.getChildCount() > 0) {
            this.tree.expandPath(new TreePath(new Object[]{this.root, this.root.getChildAt(0)}));
        }
    }

    private DefaultMutableTreeNode getSelectionTreeNode() {
        return (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    private FuzzyXMLNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof FuzzyXMLNode) {
            return (FuzzyXMLNode)node.getUserObject();
        }
        return null;
    }

    private void setTree(FuzzyXMLDocument doc) {
        this.root.removeAllChildren();
        this.doc = doc;
        if (doc != null) {
            FuzzyXMLDocType docType = doc.getDocumentType();
            if (docType != null) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(docType);
                this.root.add(node);
            }
            doc.addModifyListener(new SampleListener());
            this.setElement(this.root, doc.getDocumentElement());
        }
        this.reload(null);
    }

    private void setElement(DefaultMutableTreeNode parent, FuzzyXMLElement element) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(element);
        parent.add(node);
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            node.add(new DefaultMutableTreeNode(attrs[i]));
            ++i;
        }
        FuzzyXMLNode[] children = element.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            if (children[i2] instanceof FuzzyXMLElement) {
                this.setElement(node, (FuzzyXMLElement)children[i2]);
            } else {
                node.add(new DefaultMutableTreeNode(children[i2]));
            }
            ++i2;
        }
    }

    private String readFile(File file) throws Exception {
        String string;
        block5: {
            String encode;
            byte[] buf;
            FileInputStream in;
            block3: {
                String string2;
                block4: {
                    in = null;
                    try {
                        in = new FileInputStream(file);
                        buf = FuzzyXMLUtil.readStream(in);
                        encode = FuzzyXMLUtil.getEncoding(buf);
                        if (encode != null) break block3;
                        string2 = new String(buf);
                        Object var5_7 = null;
                        if (in == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var5_9 = null;
                            if (in == null) break block6;
                            ((InputStream)in).close();
                        }
                        throw throwable;
                    }
                    ((InputStream)in).close();
                }
                return string2;
            }
            string = new String(buf, encode);
            Object var5_8 = null;
            if (in == null) break block5;
            ((InputStream)in).close();
        }
        return string;
    }

    private String readFile(String fileName) throws Exception {
        String string;
        block9: {
            String encode;
            byte[] buf;
            InputStream in;
            block7: {
                String string2;
                block8: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("jp.aonir.fuzzyxml.sample.Console");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    URL url = clazz.getResource(fileName);
                    in = null;
                    try {
                        in = url.openStream();
                        buf = FuzzyXMLUtil.readStream(in);
                        encode = FuzzyXMLUtil.getEncoding(buf);
                        if (encode != null) break block7;
                        string2 = new String(buf);
                        Object var6_8 = null;
                        if (in == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var6_10 = null;
                            if (in == null) break block10;
                            in.close();
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return string2;
            }
            string = new String(buf, encode);
            Object var6_9 = null;
            if (in == null) break block9;
            in.close();
        }
        return string;
    }

    public static void main(String[] args) throws Exception {
        Console sample = new Console();
        sample.setDefaultCloseOperation(3);
        sample.setSize(640, 450);
        sample.setVisible(true);
    }

    private class CustomTextArea
    extends JTextArea {
        private boolean fire = true;

        CustomTextArea() {
        }

        protected void fireCaretUpdate(CaretEvent arg0) {
            if (this.fire) {
                super.fireCaretUpdate(arg0);
            }
        }
    }

    private class CustomTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private boolean fire = true;

        CustomTreeSelectionModel() {
        }

        protected void fireValueChanged(TreeSelectionEvent arg0) {
            if (this.fire) {
                super.fireValueChanged(arg0);
            }
        }
    }

    private class AddNodeAction
    extends AbstractAction {
        public AddNodeAction() {
            super("Add node");
        }

        public void actionPerformed(ActionEvent e) {
            ConsoleNodeDialog dialog;
            FuzzyXMLNode node = Console.this.getSelectedNode();
            if (node != null && node instanceof FuzzyXMLElement && (dialog = new ConsoleNodeDialog((Frame)Console.this, "Add node")).openDialog()) {
                DefaultMutableTreeNode treeNode = Console.this.getSelectionTreeNode();
                String type = dialog.getNodeType();
                String value = dialog.getValue();
                FuzzyXMLNode newNode = null;
                if (type.equals("Element")) {
                    newNode = Console.this.doc.createElement(value);
                } else if (type.equals("Comment")) {
                    newNode = Console.this.doc.createComment(value);
                } else if (type.equals("CDATA")) {
                    newNode = Console.this.doc.createCDATASection(value);
                } else if (type.equals("Text")) {
                    newNode = Console.this.doc.createText(value);
                }
                ((FuzzyXMLElement)node).appendChild(newNode);
                DefaultMutableTreeNode newTreeNode = new DefaultMutableTreeNode(newNode);
                treeNode.add(newTreeNode);
                Console.this.reload(newTreeNode);
            }
        }
    }

    private class InsertBeforeAction
    extends AbstractAction {
        public InsertBeforeAction() {
            super("Insert node before");
        }

        public void actionPerformed(ActionEvent e) {
            ConsoleNodeDialog dialog;
            FuzzyXMLNode node = Console.this.getSelectedNode();
            if (node != null && (dialog = new ConsoleNodeDialog((Frame)Console.this, "Add node")).openDialog()) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)Console.this.getSelectionTreeNode().getParent();
                String type = dialog.getNodeType();
                String value = dialog.getValue();
                int index = Console.this.model.getIndexOfChild(Console.this.getSelectionTreeNode().getParent(), Console.this.getSelectionTreeNode());
                FuzzyXMLNode newNode = null;
                if (type.equals("Element")) {
                    newNode = Console.this.doc.createElement(value);
                } else if (type.equals("Comment")) {
                    newNode = Console.this.doc.createComment(value);
                } else if (type.equals("CDATA")) {
                    newNode = Console.this.doc.createCDATASection(value);
                } else if (type.equals("Text")) {
                    newNode = Console.this.doc.createText(value);
                }
                ((FuzzyXMLElement)node.getParentNode()).insertBefore(newNode, node);
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(newNode);
                parentNode.insert(treeNode, index);
                Console.this.reload(treeNode);
            }
        }
    }

    private class ReplaceNodeAction
    extends AbstractAction {
        public ReplaceNodeAction() {
            super("Replace node");
        }

        public void actionPerformed(ActionEvent evt) {
            ConsoleNodeDialog dialog;
            FuzzyXMLNode node = Console.this.getSelectedNode();
            if (node != null && (dialog = new ConsoleNodeDialog((Frame)Console.this, "Replace node")).openDialog()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)Console.this.getSelectionTreeNode().getParent();
                String type = dialog.getNodeType();
                String value = dialog.getValue();
                int index = Console.this.model.getIndexOfChild(Console.this.getSelectionTreeNode().getParent(), Console.this.getSelectionTreeNode());
                FuzzyXMLNode newNode = null;
                if (type.equals("Element")) {
                    newNode = Console.this.doc.createElement(value);
                } else if (type.equals("Comment")) {
                    newNode = Console.this.doc.createComment(value);
                } else if (type.equals("CDATA")) {
                    newNode = Console.this.doc.createCDATASection(value);
                } else if (type.equals("Text")) {
                    newNode = Console.this.doc.createText(value);
                }
                ((FuzzyXMLElement)node.getParentNode()).replaceChild(newNode, node);
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(newNode);
                parent.remove(index);
                parent.insert(treeNode, index);
                Console.this.reload(treeNode);
            }
        }
    }

    private class AddAttrAction
    extends AbstractAction {
        public AddAttrAction() {
            super("Add attribute");
        }

        public void actionPerformed(ActionEvent evt) {
            ConsoleAttrDialog dialog;
            FuzzyXMLNode node = Console.this.getSelectedNode();
            if (node != null && node instanceof FuzzyXMLElement && (dialog = new ConsoleAttrDialog((Frame)Console.this, "Add attribute")).openDialog()) {
                DefaultMutableTreeNode treeNode = Console.this.getSelectionTreeNode();
                String name = dialog.getName();
                String value = dialog.getValue();
                FuzzyXMLAttribute attr = Console.this.doc.createAttribute(name);
                attr.setValue(value);
                ((FuzzyXMLElement)node).setAttribute(attr);
                int count = treeNode.getChildCount();
                int index = 0;
                int i = 0;
                while (i < count) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                    Object obj = child.getUserObject();
                    if (!(obj instanceof FuzzyXMLAttribute)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                DefaultMutableTreeNode newTreeNode = new DefaultMutableTreeNode(attr);
                treeNode.insert(newTreeNode, index);
                Console.this.reload(newTreeNode);
            }
        }
    }

    private class EditAttrAction
    extends AbstractAction {
        public EditAttrAction() {
            super("Edit attribute");
        }

        public void actionPerformed(ActionEvent evt) {
            DefaultMutableTreeNode treeNode = Console.this.getSelectionTreeNode();
            FuzzyXMLNode node = Console.this.getSelectedNode();
            if (node != null && node instanceof FuzzyXMLAttribute) {
                FuzzyXMLAttribute attr = (FuzzyXMLAttribute)node;
                ConsoleAttrDialog dialog = new ConsoleAttrDialog((Frame)Console.this, "Edit attribute");
                dialog.setName(attr.getName());
                dialog.setValue(attr.getValue());
                if (dialog.openDialog()) {
                    String value = dialog.getValue();
                    attr.setValue(value);
                    Console.this.reload(treeNode);
                }
            }
        }
    }

    private class EditPIAction
    extends AbstractAction {
        public EditPIAction() {
            super("Edit processing instruction");
        }

        public void actionPerformed(ActionEvent evt) {
            DefaultMutableTreeNode treeNode = Console.this.getSelectionTreeNode();
            FuzzyXMLNode node = Console.this.getSelectedNode();
            if (node != null && node instanceof FuzzyXMLProcessingInstruction) {
                FuzzyXMLProcessingInstruction pi = (FuzzyXMLProcessingInstruction)node;
                ConsolePIDialog dialog = new ConsolePIDialog((Frame)Console.this, "Edit processing instriction");
                dialog.setData(pi.getData());
                if (dialog.openDialog()) {
                    String data = dialog.getData();
                    pi.setData(data);
                    Console.this.reload(treeNode);
                }
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super("Remove");
        }

        public void actionPerformed(ActionEvent e) {
            FuzzyXMLNode node = Console.this.getSelectedNode();
            if (node != null && Console.this.doc != null) {
                DefaultMutableTreeNode treeNode = Console.this.getSelectionTreeNode();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
                treeNode.removeFromParent();
                ((FuzzyXMLElement)node.getParentNode()).removeChild(node);
                if (parent.getChildCount() == 0) {
                    Console.this.reload(parent);
                } else {
                    Console.this.reload((DefaultMutableTreeNode)parent.getChildAt(0));
                }
            }
        }
    }

    private class OutputXMLAction
    extends AbstractAction {
        public OutputXMLAction() {
            super("Output as XML");
        }

        public void actionPerformed(ActionEvent e) {
            FuzzyXMLNode node = Console.this.getSelectedNode();
            JOptionPane.showMessageDialog(Console.this, node.toXMLString());
        }
    }

    private class SampleListener
    implements FuzzyXMLModifyListener {
        SampleListener() {
        }

        public void modified(FuzzyXMLModifyEvent evt) {
            Console.this.text.setSelectionStart(evt.getOffset());
            Console.this.text.setSelectionEnd(evt.getOffset() + evt.getLength());
            Console.this.text.replaceSelection(evt.getNewText());
        }
    }

    private class SampleErrorListener
    implements FuzzyXMLErrorListener {
        public SampleErrorListener() {
            ((DefaultListModel)Console.this.errors.getModel()).removeAllElements();
        }

        public void error(FuzzyXMLErrorEvent event) {
            ((DefaultListModel)Console.this.errors.getModel()).addElement(new ErrorInfo(event.getMessage(), event.getOffset(), event.getLength()));
        }
    }

    private class ErrorInfo {
        private String message;
        private int offset;
        private int length;

        public ErrorInfo(String message, int offset, int length) {
            this.message = message;
            this.offset = offset;
            this.length = length;
        }

        public String toString() {
            return "[offset]" + this.offset + " [message]" + this.message;
        }
    }
}

