/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.xpath;

import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class FuzzyXMLAttrIterator
implements NodeIterator {
    private NodePointer parent;
    private QName name;
    private List attributes;
    private int position;

    public FuzzyXMLAttrIterator(NodePointer parent, QName name) {
        block6: {
            this.position = 0;
            this.parent = parent;
            this.name = name;
            if (!(parent.getNode() instanceof FuzzyXMLElement)) break block6;
            FuzzyXMLElement element = (FuzzyXMLElement)parent.getNode();
            String prefix = name.getPrefix();
            String lname = name.getName();
            if (prefix != null && !prefix.equals("")) {
                lname = String.valueOf(prefix) + ":" + lname;
            }
            if (!lname.equals("*")) {
                this.attributes = new ArrayList();
                FuzzyXMLAttribute[] allAttributes = element.getAttributes();
                int i = 0;
                while (i < allAttributes.length) {
                    if (allAttributes[i].getName().equals(lname)) {
                        this.attributes.add(allAttributes[i]);
                        break;
                    }
                    ++i;
                }
            } else {
                this.attributes = new ArrayList();
                FuzzyXMLAttribute[] allAttributes = element.getAttributes();
                int i = 0;
                while (i < allAttributes.length) {
                    this.attributes.add(allAttributes[i]);
                    ++i;
                }
            }
        }
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        if (this.attributes == null) {
            return false;
        }
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }

    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        return new FuzzyXMLNodePointer(this.parent, (FuzzyXMLAttribute)this.attributes.get(index));
    }
}

